function [X,W,H,Omega] = genOrthData(m,r,n)

% Optional: no permutation, to make visualization easier; it's the same anyway
% permutation = 1:m;

% Optional permutation (as real data would look)
permutation = randperm(m)';

W = zeros(m,r);
Omega = zeros(m,1);
for k=1:r
    range = floor((k-1)*m/r)+1:floor(k*m/r);
    Omega(permutation(range)) = k;
    W(permutation(range),k) = normc(abs(randn(length(range),1)));
end
H = abs(randn(r,n));
X = W * H;