from typing import List, Union
import numpy as np
from torch.utils.data import Dataset


class fMRIDataset(Dataset):
    """A typical fMRI dataset that includes fMRI recordings from several
    participants and the corresponding stimuli. Most importantly, the dataset
    assumes that the stimuli is the same across all subjects and presented to
    each participant at fixed time intervals.
    """

    dataset_name: str
    dataset_dir: str
    subjects: List[np.array]
    subject_idxs: List[Union[int, str]]

    def __init__(self):
        raise NotImplemented()

    def load_data_from_files(self):
        """Loads all data from files."""
        raise NotImplemented()

    def extract_contexts(self):
        """Extracts contexts for every word in the input text."""
        raise NotImplemented()

    def get_dataset_attributes(self):
        """Returns the dataset attributes."""
        raise NotImplemented()