import os
import random
import math
import numpy as np
import torch
import json

def set_random_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)

def mkdir(path):
    if os.path.exists(path):
        return
    else:
        mkdir(os.path.dirname(path))
        os.mkdir(path)
        return
    
def save_configs(directory, conf):
    with open(os.path.join(directory, 'config.json'), 'w') as json_file:
        json.dump(conf, json_file, indent=4)
    return
    
    
def closest_factors(n):
    sqrt_n = math.sqrt(n)
    lower_factor = math.floor(sqrt_n)
    upper_factor = math.ceil(sqrt_n)
    
    for i in range(lower_factor, 0, -1):
        if n % i == 0:
            return i, n // i
    for i in range(upper_factor, n+1):
        if n % i == 0:
            return n // i, i