# Machine Unlearning

## Preparing Dataset

### Generating Index File for a dataset

```bash
python gen_dataset_indexfile.py --dataset mnist --seed 42 --save_path outputs/dataset_indexes
```

## Training

## Scratch

```bash
python train_scratch.py --dataset mnist --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42
```

```bash
python train_scratch.py --dataset mnist --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42 --checkpoint outputs/in_models/mnist_model.pt
```

## Retraining

```bash
python train_retraining.py --dataset mnist --forget_labels 7 --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42
```

```bash
python train_retraining.py --dataset mnist --forget_labels 1 7 --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42
```

```bash
python train_retraining.py --dataset mnist --forget_labels 7 --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42 --checkpoint outputs/in_models/mnist_model.pt
```

```bash
python train_retraining.py --dataset mnist --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --index_file PATH_TO_INDEX_FILE --test_index_file PATH_TO_TEST_INDEX_FILE --weight_decay 1e-5 --seed 42 --checkpoint outputs/in_models/mnist_model.pt
```

## Uncertainty Unlearning

```bash
  python test_unlearning.py --dataset mnist --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_model.pt --use_attn_loss
```

```bash
  python test_unlearning.py --dataset mnist --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_model.pt
```

```bash
  python test_unlearning.py --dataset mnist --lr_scheduler cswr --forget_labels 1 7 --checkpoint outputs/in_models/mnist_model.pt --use_attn_loss
```

```bash
  python test_unlearning.py --dataset mnist --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_model.pt --unlearn_checkpoint outputs/models/mnist-labels:[7]-retain:2000-forget:1000-attn_loss:True.pt
```

```bash
  python test_unlearning.py --dataset mnist --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_model.pt --use_attn_loss --index_file PATH_TO_INDEX_FILE --test_index_file PATH_TO_TEST_INDEX_FILE
```

# Evaluating Machine Unlearning

```bash
python eval_unlearning.py --dataset mnist --forget_labels 7 --samples_per_member 10000 --val_percent 0.1 --batch_size 512 --seed 42 --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --checkpoints outputs/uul_uniform_kl/mnist/models/ --retrained_checkpoint outputs/retrained_main/models/mnist_retrained.pt --save_path outputs/eval --method uul
```

# Generate Indistinct Model

```bash
python gen_indistinct_model.py --dataset mnist --forget_labels 7 --num_retains 2000 --num_forgets 1000 --batch_size 1024 --learning_rate 1e-3 --alpha 0.2 --beta 0.4 --gamma 0.4 --weight_decay 1e-4 --num_epochs 10 --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --checkpoint outputs/in_models/mnist_scratch.pt --noisy_checkpoints outputs/unlearn/uul/mnist/models
```

# Eval Distinguishability

```bash
python eval_indistinguishablility.py --dataset cifar100_resnet --forget_labels 25 --batch_size 128 --index_file outputs/dataset_indexes/cifar100-train-index.csv --test_index_file outputs/dataset_indexes/cifar100-test-index.csv --checkpoints outputs/indistinct/cifar100_resnet/models/ --retrained_checkpoint outputs/forget_classes_data/retrained/models/cifar100_resnet_retrained.pt --method uul
```
