# mnist
python retraining.py --dataset mnist --forget_labels 7 --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --batch_size 1024 -lr 1e-3 --weight_decay 1e-5 --seed 42
echo "Retraining Completed"
python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "UUL Completed"
python unlearning.py --method ft --learning_rate 1e-2 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "FT Completed"
python unlearning.py --method l1_sparse --learning_rate 5e-3 --alpha 1e-4 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "l1_sparse Completed"
python unlearning.py --method ga --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "GA Completed"
python unlearning.py --method neg_grad --num_epochs 10 --learning_rate 1e-2 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "NegGrad+ Completed"
python unlearning.py --method w_fisher --alpha 50 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "Fisher IC Completed"
python unlearning.py --method random_label --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "random label"
python unlearning.py --method scrub --forget_steps 10 --num_epochs 20 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "SCRUB Completed"
python gen_saliency_masks.py --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt --batch_size 128 --seed 42 --learning_rate 1e-3 --momentum 0.01 --weight_decay 1e-5 --gpu 0
echo "Generated Saliency Map"
python unlearning.py --method salun --mask_path outputs/masks/mnist/with_0.6.pt --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
echo "SALUN Completed"
# # UUL
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --lr_scheduler cswr --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset cifar10 --index_file outputs/dataset_indexes/cifar10-train-index.csv --test_index_file outputs/dataset_indexes/cifar10-test-index.csv --lr_scheduler cswr --forget_labels 3 --checkpoint outputs/in_models/cifar10_scratch.pt
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset cifar100 --index_file outputs/dataset_indexes/cifar100-train-index.csv --test_index_file outputs/dataset_indexes/cifar100-test-index.csv --lr_scheduler cswr --forget_labels 25 --checkpoint outputs/in_models/cifar100_scratch.pt
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset cifar100_resnet --index_file outputs/dataset_indexes/cifar100-train-index.csv --test_index_file outputs/dataset_indexes/cifar100-test-index.csv --lr_scheduler cswr --forget_labels 25 --checkpoint outputs/in_models/cifar100_resnet_scratch.pt
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset ag_news --index_file outputs/dataset_indexes/ag_news-train-index.csv --test_index_file outputs/dataset_indexes/ag_news-test-index.csv --lr_scheduler cswr --forget_labels 1 --checkpoint outputs/in_models/ag_news_scratch.pt
# python unlearning.py --method uul --num_retains 2000 --num_forgets 1000 --dataset dbpedia --index_file outputs/dataset_indexes/dbpedia-train-index.csv --test_index_file outputs/dataset_indexes/dbpedia-test-index.csv --lr_scheduler cswr --forget_labels 4 --checkpoint outputs/in_models/dbpedia_scratch.pt

# # FT
# python unlearning.py --method ft --num_epochs 10 --learning_rate 2e-5 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # L1 Sparse
# python unlearning.py --method l1_sparse --num_epochs 10 --learning_rate 2e-5 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # GA
# python unlearning.py --method ga --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # NEGGRAD
# python unlearning.py --method neg_grad --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # Wfisher
# python unlearning.py --method w_fisher --alpha 0.1 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # RL
# python unlearning.py --method random_label --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # Scrub
# python unlearning.py --method scrub --forget_steps 20 --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt

# # Salun
# python unlearning.py --method salun --mask_path outputs/masks/path_here --num_epochs 10 --learning_rate 1e-3 --num_retains 2000 --num_forgets 1000 --dataset mnist --index_file outputs/dataset_indexes/mnist-train-index.csv --test_index_file outputs/dataset_indexes/mnist-test-index.csv --forget_labels 7 --checkpoint outputs/in_models/mnist_scratch.pt