default_config = {
    "load_checkpoint_run_id": None, 
    "sample_new_weight": False,

    "load_checkpoint_gan": None,
    "freeze_meta_learning": False,

    "weight_change_reparam": False,
    "weight_change_reparam_alpha": 0.1,
    "stop_loss": 0.01,
    "inner_epochs": 100,
    "inner_batch_size": 8,

    "gan_algo": "wgan_pg",
    "num_d_update": 1,
    "hypergan_batchsize": 32,
    "hypernet_hidden_dim": "128,128",
    "hypergan_noise_dim": 128,
    # "num_sample_per_task": 1,

    "meta_epochs": 500,
    "gan_optimizer": "adam",
    "gan_learning_rate": 0.0001,
    "gan_weight_decay": 0,
    "gan_adam_beta1": 0.5,
    "gan_adam_beta2": 0.999,

    "gan_momentum": 0.9,
    "gan_sgd_dampening": 0,
    "gan_sgd_nesterov": True,
    "gan_rmsprop_alpha": 0.99,

    "mainnet_hidden_dim": [256],
    "mainnet_use_bias": True,

    "inner_optimizer": "adam",
    "inner_learning_rate": 0.01,
    "inner_weight_decay": 0,
    "inner_adam_beta1": 0.9,
    "inner_adam_beta2": 0.999,
    "inner_momentum": 0,
    "inner_sgd_dampening": 0,
    "inner_sgd_nesterov": False,
    "inner_rmsprop_alpha": 0.99,

    "train_hyperclip": True,
    "train_hyperclip_on": "weights_free", # Use full weight finetune to train hyperclip ("weights_free"), or only use the weights from finetuned vae/gan embeddings ("weights_from_emb"), or train it on the embedding itself ("emb")
    "hyperclip_model": "mlp",
    "hyperclip_hidden_dim": [128,128],
    "hyperclip_batch_size": 32,

    "hyperclip_optimizer": "adam",
    "hyperclip_learning_rate": 0.002,
    "hyperclip_weight_decay": 0,
    "hyperclip_adam_beta1": 0.9,
    "hyperclip_adam_beta2": 0.999,
    "hyperclip_momentum": 0.9,
    "hyperclip_sgd_dampening": 0,
    "hyperclip_sgd_nesterov": True,
    "hyperclip_rmsprop_alpha": 0.99,

    "val_epoch_interval": 10,
    "clip_model": "ViT-L/14@336px",

    "save_checkpoint": True
}
