default_config = {
    "hypnettorch": False,        # Enables the legacy hypnettorch library for the hnet setting
    
    "meta_process": "reptile",     #one of "hnet" (baseline hypernet), "reptile" (common init) and "random_init" (for random init hyperclip training)
    "freeze_meta_learning": False,      #Override all meta-learning processes such as hnet/mnet reptile (used with loaded checkpoints to keep reloading a fixed net inbetween inner loop finetunings)
    "weight_change_reparam": False,
    "weight_change_reparam_alpha": 0.1,

    "hypernet_type": "mlp",

    "mainnet_hidden_dim": [256],
    "mainnet_use_bias": True,
    "hypernet_hidden_dim": [32],
    #"hypernet_init": "hyperfan",
    "hypernet_init": "standard",
    "hypernet_chunk_size": 50000,

    "meta_epochs": 200,
    "meta_stepsize_start": 0.01,
    "meta_stepsize_final": 0.01,

    "stop_loss": 0.01,              #Stop training if loss is below this value, "None" to disable
    "inner_epochs": 100,
    "inner_batch_size": 32,
    "inner_optimizer": "adam",
    "inner_learning_rate": 0.01,
    "inner_weight_decay": 0,
    "inner_adam_beta1": 0.9,
    "inner_adam_beta2": 0.999,
    "inner_momentum": 0,
    "inner_sgd_dampening": 0,
    "inner_sgd_nesterov": False,
    "inner_rmsprop_alpha": 0.99,

    "train_hyperclip": True,
    "hyperclip_model": "mlp",
    "hyperclip_hidden_dim": [1500,1024,768],
    "hyperclip_batch_size": 32,

    "hyperclip_optimizer": "adam",
    "hyperclip_learning_rate": 0.002,
    "hyperclip_weight_decay": 0,
    "hyperclip_adam_beta1": 0.9,
    "hyperclip_adam_beta2": 0.999,
    "hyperclip_momentum": 0.9,
    "hyperclip_sgd_dampening": 0,
    "hyperclip_sgd_nesterov": True,
    "hyperclip_rmsprop_alpha": 0.99,

    "val_epoch_interval": 10,

    "clip_model": "ViT-L/14@336px",
    #"clip_model": "RN50",

    "save_checkpoint": True

}
