# PyTorch implementation of RealUID


This repository provides training scripts and utilities for RealUID distillation on CIFAR datasets.  
It includes both from-scratch training and fine-tuning pipelines with optional GAN-based loss integration.

---

## 🚀 Getting Started

### 🔧 Requirements
- Python ≥ 3.9
- PyTorch
- torchvision

Install dependencies (ensure correct CUDA version if using GPU):
```bash
pip install torch torchvision
```

---

## 📂 Repository Structure

```
.
├── cifar_adv.py               # Train distillation from scratch
├── cifar_adv_finetune.py      # Fine-tune a pretrained distilled model
├── huggingface_download.py    # (Optional) Download models from HuggingFace
└── utils_cifar.py             # CIFAR training utilities
```

---

## 🏋️‍♂️ Train from Scratch

Run:
```bash
python cifar_adv.py
```

### Arguments

| Argument            | Type    | Default  | Description                    |
|---------------------|---------|----------|--------------------------------|
| `--alpha`           | float   | `1.0`    | alpha weight |
| `--gamma`           | float   | `1.0`    | beta weight (in the text)      |
| `--gen_coef`        | float   | `None`   | Generator loss weight (GAN)   |
| `--disc_coef`       | float   | `None`   | Discriminator loss weight     |
| `--with_gan_loss`   | flag    | `False`  | Enable GAN loss               |
| `--ckpt_path`       | string  | `None`   | Resume training from checkpoint |

### Example

```bash
# Basic training
python cifar_adv.py --alpha 1.0 --gamma 1.0

# With adversarial loss
python cifar_adv.py --with_gan_loss --gen_coef 0.5 --disc_coef 0.5
```

---

## 🔧 Fine-tune Distilled Model

Run:
```bash
python cifar_adv_finetune.py
```

### Arguments

| Argument              | Type    | Default | Description                        |
|------------------------|---------|---------|------------------------------------|
| `--alpha`             | float   | `0.98`  | alpha weight     |
| `--gamma`             | float   | `0.96`  | beta weight (in the text)          |
| `--gen_coef`          | float   | `None`  | Generator loss weight (GAN)       |
| `--disc_coef`         | float   | `None`  | Discriminator loss weight         |
| `--with_gan_loss`     | flag    | `False` | Enable GAN loss                   |
| `--finetune_path`     | string  | `-`     | Path to pretrained model to finetune |

### Example

```bash
# Fine-tune existing model
python cifar_adv_finetune.py --finetune_path checkpoints/model_base.pt

# With adversarial loss
python cifar_adv_finetune.py --finetune_path checkpoints/model_base.pt \
  --with_gan_loss --gen_coef 0.25 --disc_coef 0.25

# Change KD hyperparameters
python cifar_adv_finetune.py --finetune_path checkpoints/model_base.pt \
  --alpha 0.98 --gamma 0.96
```

---

## 📌 Notes

- CIFAR datasets will be auto-downloaded via `torchvision`.
- Use `--with_gan_loss` only when `--gen_coef` and `--disc_coef` are provided.
- Fine-tuning assumes an already distilled checkpoint (`--finetune_path`).
