"""
    script is aimed to circumvent ssl validation for checkpoint loading from Huggingface by
    overriding the _request_wrapper function to skip SSL validation
    to activate please import the module and execute apply_patch function
"""
from huggingface_hub import file_download

__all__ = ["apply_patch"]

original_wrapper = file_download._request_wrapper


def non_verifying_request_wrapper(*args, **kwargs):
    #print("NON-VERIFYING request wrapper")
    return original_wrapper(*args, **{**{'verify': False}, **kwargs})



import urllib.request as R
import ssl

urlopen_orig = R.urlopen


def urlopen_nossl(*args, **kwargs):
    print("urlopen NOSSL CONTEXT")
    ctx = ssl.create_default_context()
    ctx.check_hostname = False
    ctx.verify_mode = ssl.CERT_NONE

    kwargs = dict(kwargs)
    if 'context' in kwargs:
        print("Warning, replacing Request context", kwargs['context'])
    kwargs['context'] = ctx
    return urlopen_orig(*args, **kwargs)


def switch_ssl_to_insecure():
    import ssl
    ssl._create_default_https_context = ssl._create_unverified_context



def apply_patch():
    print("Monkey patch for HuggingFace.file_download._request_wrapper is activated!!!")
    file_download._request_wrapper = non_verifying_request_wrapper

    print("Monkey patch for urllib.request.urlopen activated!!!")
    R.urlopen = urlopen_nossl

    print("Disabling SSL verifying")
    switch_ssl_to_insecure()