# Hadamard
DEPTH = 2
LA = 5e-4
INIT_TYPE = 'ones' # vanilla, equivar, root, ones
INIT = 'tf.keras.initializers.HeNormal()'
USE_BIAS = True # only for dense layers
FACTORIZE_BIAS = True

# Training
PRETRAIN_OPT = 'sgd' # sgd, adam
LR_SCHEDULE = 'cosine' # piecewise, constant, cosine
BATCH_SIZE = 256 #256
EPOCHS = 100 #200
INIT_LR = 0.3 if PRETRAIN_OPT == 'sgd' else 2e-3 # depth 2=0.2, depth3 3 = 0.5, depth 4 = 0.7
WARMUP = False # linear lr warmup from 0.01 to INIT_LR over 5 epochs
MOMENTUM = 0.9 # only for SGD
LR_DECAY_FACT = 0.1 # only for piecewise
LARGE_LRSTART = False # only for piecewise

# Misc
CLASS_NUM = 8
PAT = 100
RESTORE_WEIGHTS = False
GRACE = 10
FINE_GRACE = 20
MINACC = (1 / CLASS_NUM) + 0.01
SEED = 123
SAVE_METRICS = True
VERBOSE = 0
WARMSTARTS = False

# Lambda grid
LAMBDA_LIST = [
    1e-10,
    1e-5,
    1e-4,
    2e-4,
    5e-4,
    7e-4,
    8e-4,
    9e-4,
    1e-3,
    1.5e-3,
    2e-3,
    4e-3,
    5e-3,
    8e-3,
    1e-2,
    1.5e-2,
    2e-2,
    2.5e-2,
    3e-2,
    3.5e-2,
    4e-2,
    4.5e-2,
    5e-2,
    5.5e-2,
    6e-2,
    6.5e-2,
    7e-2,
    8e-2,
    9e-2,
    1e-1,
    2e-1,
    5e-1,
    7e-1,
    1,
    2
]