#include "random.h"

#include <cassert>

RandomTool::RandomTool (long long seed, long long prime) : rng(seed), prime(prime) {}

long long RandomTool::getRandom (long long l, long long r) {
	assert(l <= r);
	return std::uniform_int_distribution<long long>(l, r)(this->rng);
}

long long RandomTool::getRandomSmallerPrime () {
	return this->getRandom(1, prime - 1);
}

long long RandomTool::getPrime () const {
	return this->prime;
}
