SOLVED=0
TOTALDURATION=0

for inputfile in eight_nodes/input*.txt; do
	echo -n "Testing $inputfile: "
	START=$(date +%s%N)
	taskset --cpu-list 3 timeout 60 ./fast.out --testing --prime 999999999900000059 < $inputfile > tmp.txt
	END=$(date +%s%N)
	DURATION=$((END-START))

    solfile=$( echo $inputfile | sed 's/\in/\out/')

    cat tmp.txt | diff -Z "$solfile" - >> /dev/null
    if [[ $? == 0 ]]; then
		echo "Solved correctly in $DURATION ns"
		SOLVED=$((SOLVED+1))
		TOTALDURATION=$((TOTALDURATION+DURATION))
    else
		echo "Not solved correctly"
    fi

	rm tmp.txt
done

echo "Solved $SOLVED/879 samples in $TOTALDURATION ns"
