#include <cassert>
#include <cstring>
#include <iostream>

int main () {
	int n;
	std::cin >> n;

	std::cout << "\nvar g = new Graph();\ng.init(0)\n\n";
	std::cout << "for (let i = 0; i < " << n << "; i++) {\n   g.addVertex(i.toString());\n}\n\n";

	for (int i = 1; i < n; i++) {
		int parent;
		std::cin >> parent;
		std::cout << "g.addEdge(\"" << parent << "\", \"" << i << "\", Graph.Edgetype.Directed);\n";
	}

	std::cout << "\n";

	int m;
	std::cin >> m;
	for (int i = 0; i < m; i++) {
		int u, v;
		std::cin >> u >> v;
		std::cout << "g.addEdge(\"" << u << "\", \"" << v << "\", Graph.Edgetype.Bidirected);\n";
	}

	std::cout << "\nvar r = GraphAnalyzer.treeID(g).results;\n\n";
	std::cout << "for (let i = 1; i < " << n << "; i++) {\n";
	std::cout << "   if (i.toString() in r) {\n";
	std::cout << "      process.stdout.write(r[i.toString()][0].fastp.length.toString());\n";
	std::cout << "      process.stdout.write(\" \");\n";
	std::cout << "   } else {\n";
	std::cout << "      process.stdout.write(\"0 \");\n";
	std::cout << "   }\n}\nprocess.stdout.write(\"\\n\");\n";
}
