#include <cassert>
#include <cstring>
#include <iostream>
#include <vector>

int main () {
	int n;
	std::cin >> n;

	std::vector<std::vector<int>> dir(n, std::vector<int>(n)), bi(n, std::vector<int>(n));

	for (int i = 1; i < n; i++) {
		int parent;
		std::cin >> parent;
		dir[parent][i] = 1;
	}

	int m;
	std::cin >> m;
	for (int i = 0; i < m; i++) {
		int u, v;
		std::cin >> u >> v;
		bi[u][v] = bi[v][u] = 1;
	}

	std::cout << "library(SEMID)\n";
	std::cout << "L = t(matrix(c(";

	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (i || j) std::cout << ", ";
			std::cout << dir[i][j];
		}
	}
	
	std::cout << "), " << n << ", " << n << "))\n\n";
	std::cout << "O = t(matrix(c(";

	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (i || j) std::cout << ", ";
			std::cout << bi[i][j];
		}
	}

	std::cout << "), " << n << ", " << n << "))\n\n";
	std::cout << "graph = MixedGraph(L, O)\n\n";
	std::cout << "htcID(graph)\n";
}
