SOLVED=0
TOTALDURATION=0

for inputfile in eight_nodes/input*.txt; do
	echo -n "Testing $inputfile: "

	cp treeID.js tmp.js
	./test_to_js.out < $inputfile >> tmp.js

	START=$(date +%s%N)
	taskset --cpu-list 3 timeout 7200 node --max_old_space_size=4096 tmp.js > tmp.txt
	END=$(date +%s%N)
	DURATION=$((END-START))

    solfile=$( echo $inputfile | sed 's/\in/\out/')

    cat tmp.txt | diff -Z "$solfile" - >> /dev/null
    if [[ $? == 0 ]]; then
		echo "Solved correctly in $DURATION ns"
		SOLVED=$((SOLVED+1))
		TOTALDURATION=$((TOTALDURATION+DURATION))
    else
		echo "Not solved correctly"
    fi

	rm tmp.txt tmp.js
done

echo "Solved $SOLVED/879 samples in $TOTALDURATION ns"
