import os
import torch
import pickle

# 指定包含.pt文件的文件夹路径
folder_path = './tsp'

# 遍历文件夹中的所有文件
for filename in os.listdir(folder_path):
    # 检查文件是否是.pt文件
    if filename.endswith('.pt'):
        # 加载.pt文件
        data = torch.load(os.path.join(folder_path, filename))

        # 将数据保存为.pkl文件
        with open(os.path.join(folder_path, filename[:-3] + '.pkl'), 'wb') as f:
            pickle.dump(data, f)
