(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     35281,        755]
NotebookOptionsPosition[     32572,        697]
NotebookOutlinePosition[     33093,        717]
CellTagsIndexPosition[     33050,        714]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebraic Failures: The ",
 Cell[BoxData[
 Cell["mushroom", "InlineCode",ExpressionUUID->
   "8c3c66ad-4ba8-4e02-9e14-6c964f65b1e1"]], "InlineCode",ExpressionUUID->
  "0a0cd5ad-1ccd-4580-b3d1-648e8e915c08"],
 " dataset"
}], "Title",
 CellChangeTimes->{{3.870416494807392*^9, 3.8704165149389963`*^9}, {
   3.8728244644751368`*^9, 3.872824492105381*^9}, {3.8773347884125433`*^9, 
   3.877334789157092*^9}, 3.877334864620109*^9, {3.87733489498519*^9, 
   3.8773349089413977`*^9}, {3.877334992371562*^9, 3.8773351453602657`*^9}, {
   3.878564688139502*^9, 3.878564691112658*^9}, {3.89283727077804*^9, 
   3.8928372720213346`*^9}, {3.89324412244477*^9, 3.893244124125347*^9}, {
   3.893890489224846*^9, 
   3.893890493029376*^9}},ExpressionUUID->"bcd3c995-0cc1-4a17-bbbb-\
3a732f1bacde"],

Cell[TextData[{
 "An experimental demonstration, using the UCI ",
 StyleBox["mushroom",
  FontFamily->"Roboto",
  FontWeight->"Bold"],
 " dataset, that the failures of the independent stream evaluator for binary \
classifiers can be used to find nearly independent trios on unlabeled data.\n\
\nWe read some common code for the three datasets"
}], "Text",
 CellChangeTimes->{{3.870416560007392*^9, 3.870416687666049*^9}, {
   3.870416753673461*^9, 3.8704167843086433`*^9}, {3.87041688019711*^9, 
   3.8704179787978563`*^9}, {3.872824630802247*^9, 3.8728247465135*^9}, {
   3.872824879536249*^9, 3.8728249904066057`*^9}, {3.872825028580565*^9, 
   3.872825446071165*^9}, {3.8728254796306057`*^9, 3.87282561291549*^9}, {
   3.8728256473624372`*^9, 3.872825818229589*^9}, 3.877335170454104*^9, {
   3.877335277799707*^9, 3.8773354135556*^9}, {3.878099685485421*^9, 
   3.8780997076315107`*^9}, {3.87809973956047*^9, 3.8780997425274563`*^9}, {
   3.878099796200707*^9, 3.878099931047056*^9}, {3.878099971417561*^9, 
   3.878100047695458*^9}, {3.878100122890733*^9, 3.878100303698058*^9}, {
   3.8781003527565737`*^9, 3.8781004720109653`*^9}, {3.8781005092652884`*^9, 
   3.87810063813365*^9}, {3.8781006707957087`*^9, 3.878100741599815*^9}, {
   3.878100774302137*^9, 3.87810081023703*^9}, {3.878564714269315*^9, 
   3.8785647456558104`*^9}, {3.8925688550785017`*^9, 3.892568909688491*^9}, {
   3.8925689522365837`*^9, 3.892568957413231*^9}, {3.8926513345657377`*^9, 
   3.892651353914339*^9}, {3.8932441274487762`*^9, 
   3.893244130807*^9}},ExpressionUUID->"4d69d43d-fca1-4c9f-b4de-bc7c9c8ddb12"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nbDir", " ", "=", " ", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "nbDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NotebookEvaluate", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"nbDir", ",", "\"\<CommonCode.nb\>\""}], "}"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.892651664814858*^9, 3.892651706773838*^9}, {
  3.892651804438521*^9, 3.892651823515175*^9}, {3.892651929726159*^9, 
  3.892651930016461*^9}, {3.8926519786606703`*^9, 3.892652021585513*^9}, {
  3.892652053162012*^9, 3.892652071400268*^9}, {3.892652113572515*^9, 
  3.8926522011251793`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"9ffd75ab-68ca-421a-8eba-4c022a1bd3ec"],

Cell[CellGroupData[{

Cell["Getting the data and taking a look at the available features", "Section",
 CellChangeTimes->{{3.870418735367992*^9, 3.8704187695502863`*^9}, {
  3.870596606676496*^9, 3.8705966396036253`*^9}, {3.877335429643175*^9, 
  3.877335448437654*^9}},ExpressionUUID->"e4431d5b-799b-40cd-89da-\
495df9619242"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tsvHeader", ",", " ", "benchmarkData"}], "}"}], " ", "=", " ", 
   RowBox[{"ImportPennMLBenchmarksDataset", "[", "\"\<mushroom\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8705235525461493`*^9, 3.8705235571860437`*^9}, {
  3.870596259432252*^9, 3.870596283037717*^9}, {3.877335452972402*^9, 
  3.877335454315721*^9}, {3.878564774795635*^9, 3.878564776872191*^9}, {
  3.8932441455542316`*^9, 3.893244148446108*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"07259698-ce42-481a-baae-128f16fcde68"],

Cell[CellGroupData[{

Cell[BoxData["tsvHeader"], "Input",
 CellChangeTimes->{{3.870523583077188*^9, 3.8705235866731453`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"b1262ebf-6e0a-4983-8bcb-4a655a305a0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cap-shape\"\>", ",", "\<\"cap-surface\"\>", 
   ",", "\<\"cap-color\"\>", ",", "\<\"bruises?\"\>", ",", "\<\"odor\"\>", 
   ",", "\<\"gill-attachment\"\>", ",", "\<\"gill-spacing\"\>", 
   ",", "\<\"gill-size\"\>", ",", "\<\"gill-color\"\>", 
   ",", "\<\"stalk-shape\"\>", ",", "\<\"stalk-root\"\>", 
   ",", "\<\"stalk-surface-above-ring\"\>", 
   ",", "\<\"stalk-surface-below-ring\"\>", 
   ",", "\<\"stalk-color-above-ring\"\>", 
   ",", "\<\"stalk-color-below-ring\"\>", ",", "\<\"veil-type\"\>", 
   ",", "\<\"veil-color\"\>", ",", "\<\"ring-number\"\>", 
   ",", "\<\"ring-type\"\>", ",", "\<\"spore-print-color\"\>", 
   ",", "\<\"population\"\>", ",", "\<\"habitat\"\>", ",", "\<\"target\"\>"}],
   "}"}]], "Output",
 CellChangeTimes->{3.870523588133562*^9, 3.870596289409478*^9, 
  3.871638540395935*^9, 3.871706906357135*^9, 3.8717090853936033`*^9, 
  3.871717587823229*^9, 3.871724110745204*^9, 3.871969349503574*^9, 
  3.87197171029183*^9, 3.8720667345791607`*^9, 3.872073865428359*^9, 
  3.872306715558063*^9, 3.872314473142736*^9, 3.872826635366192*^9, 
  3.877335466343186*^9, 3.877591423809586*^9, 3.8781008907356997`*^9, 
  3.8785647846498623`*^9, 3.892618866971345*^9, 3.892652289872514*^9, 
  3.8926525157893887`*^9, 3.892658191498096*^9, 3.892702201789298*^9, 
  3.8927067899981623`*^9, 3.8928073707791862`*^9, 3.892830123500276*^9, 
  3.892834462067335*^9, 3.892841345747596*^9, 3.892841406487049*^9, 
  3.89288565088008*^9, 3.89293122761207*^9, 3.8932486538336554`*^9, 
  3.893293626575667*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"f036917b-d526-442f-b72c-68e57756a9a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["mushroomFeatures"], "Input",
 CellChangeTimes->{{3.877337437293154*^9, 3.877337494888242*^9}, {
  3.87856495603835*^9, 3.878564957383402*^9}, {3.8932441538512983`*^9, 
  3.89324415620382*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"3b8fc3ea-e203-41e6-ad3a-743159983f76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "\<\"Nominal\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.87733746349279*^9, 3.877337495986581*^9, 
  3.8775914317621183`*^9, 3.878101069518462*^9, 3.878564958376603*^9, 
  3.879148827749604*^9, 3.892618873302746*^9, 3.892619039399386*^9, 
  3.892652289910068*^9, 3.892652515826212*^9, 3.892658191539904*^9, 
  3.892702201821457*^9, 3.892706790019773*^9, 3.8928073707954206`*^9, 
  3.89283012352526*^9, 3.892834462102223*^9, 3.8928413457693233`*^9, 
  3.892841406506752*^9, 3.89288565089988*^9, 3.892931227630509*^9, 
  3.8932486538599987`*^9, 3.893293626602791*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"5e25851d-7963-485b-93b5-434c7746b557"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "benchmarkData"}]], "Input",
 CellChangeTimes->{{3.877336562112534*^9, 3.877336573343268*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"bd421011-0606-4dfc-9ca4-d6d0aab68c16"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"0", "\[Rule]", "4208"}], ",", 
   RowBox[{"1", "\[Rule]", "3916"}]}], "\[RightAssociation]"}]], "Output",
 CellChangeTimes->{{3.8773365661609*^9, 3.877336574467449*^9}, 
   3.877591436393881*^9, 3.878101086643124*^9, 3.878565012931489*^9, 
   3.87914888292692*^9, 3.892619050708255*^9, 3.89265228999396*^9, 
   3.8926525159000063`*^9, 3.8926581916240587`*^9, 3.892702201888033*^9, 
   3.892706790078054*^9, 3.8928073708463287`*^9, 3.892830123584457*^9, 
   3.8928344621592712`*^9, 3.892841345816963*^9, 3.892841406552682*^9, 
   3.8928856509549007`*^9, 3.8929312276826963`*^9, 3.8932486538871717`*^9, 
   3.893293626636784*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"bbc72ee6-97c3-42a2-ae1a-ee01991e6d92"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Independent AE failure modes", "Section",
 CellChangeTimes->{{3.8926330662251787`*^9, 
  3.8926330775430317`*^9}},ExpressionUUID->"974e8ac3-7766-4380-b0c0-\
8ee12711fd4a"],

Cell["\<\
Define a sample of disjoint feature partitions to use in the experiments\
\>", "Text",
 CellChangeTimes->{{3.8926331321984262`*^9, 
  3.8926331599319696`*^9}},ExpressionUUID->"2547b084-d74c-4178-834e-\
2fb4403340ce"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"featurePartitions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"RandomSample", "[", "mushroomFeatures", "]"}], "//", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Partition", "[", 
             RowBox[{"#", ",", 
              RowBox[{"UpTo", "@", "3"}]}], "]"}], "&"}]}], "//", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Take", "[", 
            RowBox[{"#", ",", "3"}], "]"}], "&"}]}], ",", 
         RowBox[{"{", "1000", "}"}]}], "]"}], "//", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"Sort", ",", "#", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
      RowBox[{
       RowBox[{"Sort", "/@", "#"}], "&"}]}], "//", "DeleteDuplicates"}], "//", 
    RowBox[{
     RowBox[{"RandomSample", "[", 
      RowBox[{"#", ",", "100"}], "]"}], "&"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "@", "featurePartitions"}]}], "Input",
 CellChangeTimes->{{3.878103516336095*^9, 3.8781036511605873`*^9}, {
  3.892621425523336*^9, 3.892621443933825*^9}, {3.8926331684555063`*^9, 
  3.892633169118384*^9}, {3.8928855859454823`*^9, 3.892885597553267*^9}, {
  3.893244107957097*^9, 3.893244108477178*^9}, {3.89324418712073*^9, 
  3.893244190558338*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"34aeda70-3d0d-48e8-b705-5bddbf3e8497"],

Cell[BoxData["100"], "Output",
 CellChangeTimes->{
  3.878103653012848*^9, 3.892621450439123*^9, 3.892633169900721*^9, 
   3.892652222581903*^9, 3.892652520820962*^9, 3.892658194748084*^9, 
   3.8927022055937977`*^9, 3.892706790106865*^9, 3.8927135299442787`*^9, 
   3.892786717278211*^9, 3.892807370878928*^9, {3.892830108355489*^9, 
   3.892830123625553*^9}, 3.892834462206252*^9, 3.892841345846715*^9, 
   3.892841406578546*^9, 3.892885650979219*^9, 3.892909149683988*^9, 
   3.892931227710581*^9, 3.893248653915886*^9, 3.893293632866413*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"67b7c5b8-04bc-4d5f-ac6e-c67ea75e1192"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number of decision patterns as a function of test size", "Subsubsection",
 CellChangeTimes->{{3.892633095307786*^9, 
  3.892633113071637*^9}},ExpressionUUID->"c195a4fa-9f2f-4360-879f-\
a2faf7fcdb35"],

Cell[CellGroupData[{

Cell["Getting runs from 100 to 1000 in steps of 100", "Item",
 CellChangeTimes->{{3.892648458891638*^9, 3.892648488300338*^9}, {
  3.8927032054751377`*^9, 
  3.892703215512033*^9}},ExpressionUUID->"5e921a0c-4f74-442c-9389-\
6cf257ab0336"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nTrain", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"globalTrainSize", "=", "600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nClassifiers", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"classifierTypes", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<LogisticRegression\>\"", ",", 
        RowBox[{"\"\<L1Regularization\>\"", "->", "0.1"}], ",", 
        RowBox[{"\"\<L2Regularization\>\"", "->", "0.5"}], ",", 
        RowBox[{"\"\<OptimizationMethod\>\"", "->", "\"\<Newton\>\""}]}], 
       "}"}], ",", 
      RowBox[{"{", "nClassifiers", "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"We", " ", "separate", " ", "a", " ", "held"}], "-", 
    RowBox[{
    "out", " ", "test", " ", "set", " ", "that", " ", "is", " ", "never", " ",
      "seen", " ", "in", " ", "any", " ", "of", " ", "the", " ", "training", 
     "\[IndentingNewLine]", "runs", " ", "below"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aTrainIndices", " ", "=", " ", 
   RowBox[{"RandomSample", "[", 
    RowBox[{
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", 
       RowBox[{"benchmarkData", "[", "0", "]"}]}]}], ",", "globalTrainSize"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bTrainIndices", " ", "=", " ", 
   RowBox[{"RandomSample", "[", 
    RowBox[{
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", 
       RowBox[{"benchmarkData", "[", "1", "]"}]}]}], ",", "globalTrainSize"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"globalTrainTestSplit", " ", "=", 
   RowBox[{"MakeTrainTestSplit", "[", 
    RowBox[{
    "benchmarkData", ",", "aTrainIndices", ",", " ", "bTrainIndices"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"globalTrainData", " ", "=", " ", 
   RowBox[{"SelectTrainDataFromSplit", "[", "globalTrainTestSplit", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"globalHOData", " ", "=", " ", 
   RowBox[{"SelectTestDataFromSplit", "[", "globalTrainTestSplit", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"runs", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"nTest", "->", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Select", " ", "random"}], ",", " ", 
          RowBox[{
          "disjoint", " ", "partitions", " ", "of", " ", "the", " ", 
           "training", " ", "data"}], ",", "\[IndentingNewLine]", 
          RowBox[{"grouped", " ", "by", " ", "classifier"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"trainIndices", "=", 
           RowBox[{"Transpose", "@", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a", 
               " ", "subset", " ", "of", " ", "the", " ", "alpha", " ", 
               "training", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
             
             RowBox[{
              RowBox[{"ClassifiersSampleIndices", "[", 
               RowBox[{
                RowBox[{"globalTrainData", "[", "0", "]"}], ",", "nTrain"}], 
               "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
               "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a", 
                " ", "subset", " ", "of", " ", "the", " ", "beta", " ", 
                "training", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
              RowBox[{"ClassifiersSampleIndices", "[", 
               RowBox[{
                RowBox[{"globalTrainData", "[", "1", "]"}], ",", " ", 
                "nTrain"}], "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Prepare", " ", "the", " ", "training", " ", "data", " ", "for", 
            " ", "the", " ", "current", " ", "feature", " ", "partitions"}], 
           " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"trainClassifiersData", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", 
                  RowBox[{"First", "@", 
                   RowBox[{"Transpose", "@", "features"}]}], "]"}], "]"}], 
                "&"}], ",", "globalTrainData", ",", 
               RowBox[{"{", "2", "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"features", ",", "classifiersFeatures"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"classifiers", " ", "=", " ", 
           RowBox[{"TrainClassifiersDisjoint", "[", 
            RowBox[{
            "trainClassifiersData", ",", "classifierTypes", ",", 
             "trainIndices", ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Last", "@", 
                  RowBox[{"Transpose", "@", "#"}]}], ")"}], "&"}], ",", 
               "classifiersFeatures"}], "]"}], ",", "\"\<TrainingSpeed\>\""}],
             "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Now", " ", "evaluate"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"evalIndices", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a", 
              " ", "subset", " ", "of", " ", "the", " ", "alpha", " ", 
              "training", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SampleIndices", "[", 
              RowBox[{
               RowBox[{"globalHOData", "[", "0", "]"}], ",", "nTest"}], "]"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a", 
               " ", "subset", " ", "of", " ", "the", " ", "beta", " ", 
               "training", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
             
             RowBox[{"SampleIndices", "[", 
              RowBox[{
               RowBox[{"globalHOData", "[", "1", "]"}], ",", " ", "nTest"}], 
              "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"testClassifiersData", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", 
                  RowBox[{"First", "@", 
                   RowBox[{"Transpose", "@", "features"}]}], "]"}], "]"}], 
                "&"}], ",", 
               RowBox[{"SelectFromData", "[", 
                RowBox[{"globalHOData", ",", 
                 RowBox[{"First", "@", "evalIndices"}], ",", 
                 RowBox[{"Last", "@", "evalIndices"}]}], "]"}], ",", 
               RowBox[{"{", "2", "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"features", ",", "classifiersFeatures"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"vcbl", "=", 
           RowBox[{"LabelCounts", "[", 
            RowBox[{"classifiers", ",", "testClassifiersData"}], "]"}]}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"Which", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{"HasAllDecisionFrequenciesQ", "@", " ", "vcbl"}]}], " ", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Not", "@", 
             RowBox[{"IndependentEvaluationIdealIsNonEmptyQ", "@", "vcbl"}]}],
             ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"sols", "=", 
              RowBox[{
              "AlgebraicallyEvaluateClassifiers", "[", "vcbl", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Not", "@", 
              RowBox[{"HasOnlyRealNumbersQ", "@", "sols"}]}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Not", "@", 
             RowBox[{"InsideUnitCubeQ", "@", "sols"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
            "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"classifiersFeatures", ",", "featurePartitions"}], "}"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"nTest", ",", "100", ",", "1000", ",", "100"}], "}"}]}], 
     "]"}]}], ";"}], "]"}]}], "Input",
 CellChangeTimes->{{3.871887479716145*^9, 3.871887497599922*^9}, {
   3.871887552413165*^9, 3.871887558477096*^9}, {3.871887593171126*^9, 
   3.87188764431096*^9}, {3.871887686763433*^9, 3.871887692212328*^9}, {
   3.871887727296193*^9, 3.8718877283103943`*^9}, {3.8718877651522017`*^9, 
   3.871887807486765*^9}, {3.871888215481052*^9, 3.871888232125287*^9}, {
   3.871893900342667*^9, 3.871893976322942*^9}, {3.871894017013279*^9, 
   3.871894017727285*^9}, {3.8718940499823837`*^9, 3.8718940508207903`*^9}, {
   3.87189411356434*^9, 3.871894114478372*^9}, {3.871894174445038*^9, 
   3.871894223777006*^9}, {3.87191865644144*^9, 3.871918658315392*^9}, {
   3.8719187017243834`*^9, 3.8719187038520727`*^9}, {3.8719187388586617`*^9, 
   3.871918764692956*^9}, {3.871918816847649*^9, 3.871918844645383*^9}, {
   3.871918954294279*^9, 3.8719189975134993`*^9}, {3.87191940832541*^9, 
   3.87191943334023*^9}, {3.871919513262493*^9, 3.871919556126436*^9}, {
   3.871919595363358*^9, 3.871919598959486*^9}, {3.8719197278383703`*^9, 
   3.8719197351271553`*^9}, {3.871921824740267*^9, 3.871921825411461*^9}, {
   3.871921911904357*^9, 3.8719219969879093`*^9}, 3.871931921883073*^9, {
   3.8719320831776237`*^9, 3.8719321200026827`*^9}, {3.871932173846888*^9, 
   3.871932174547483*^9}, {3.871932235180825*^9, 3.871932262718889*^9}, {
   3.871932295690782*^9, 3.871932340853784*^9}, {3.8719323919244537`*^9, 
   3.871932396522873*^9}, {3.871932434080082*^9, 3.871932451731018*^9}, {
   3.871932488390277*^9, 3.871932522020731*^9}, {3.871965421861615*^9, 
   3.871965475110799*^9}, {3.871965542082204*^9, 3.871965547647353*^9}, {
   3.871965695471809*^9, 3.8719656960448713`*^9}, {3.871966278785927*^9, 
   3.871966282908985*^9}, {3.871966817237946*^9, 3.871966818003621*^9}, {
   3.871966858118101*^9, 3.871966858940407*^9}, {3.8719673116266108`*^9, 
   3.871967312579108*^9}, {3.87196751805786*^9, 3.871967521116004*^9}, {
   3.871967567371355*^9, 3.871967567757503*^9}, {3.8719676976387653`*^9, 
   3.8719677055039377`*^9}, {3.8719677834919643`*^9, 3.871967810869413*^9}, {
   3.8719679426894627`*^9, 3.871967947792926*^9}, {3.871968035579925*^9, 
   3.8719680648357773`*^9}, {3.871968114832329*^9, 3.871968128297131*^9}, {
   3.871968166143262*^9, 3.871968166715526*^9}, {3.871968257394113*^9, 
   3.871968262555895*^9}, {3.87196829321392*^9, 3.8719682942876463`*^9}, {
   3.871973106661717*^9, 3.871973112861516*^9}, {3.871973193094653*^9, 
   3.871973194232027*^9}, {3.871973360734042*^9, 3.871973373126989*^9}, {
   3.8719734093591537`*^9, 3.871973409727911*^9}, {3.871973447884165*^9, 
   3.871973503831283*^9}, {3.8719761295885897`*^9, 3.8719761358070602`*^9}, {
   3.8719761852220716`*^9, 3.871976381712061*^9}, {3.8720526033004*^9, 
   3.872052625884467*^9}, {3.872052821894945*^9, 3.8720528243334293`*^9}, {
   3.872053599730405*^9, 3.872053632697014*^9}, {3.872053813266049*^9, 
   3.872053814390523*^9}, {3.872307945267033*^9, 3.872308036769537*^9}, {
   3.872308070713026*^9, 3.872308150349695*^9}, {3.872308199844627*^9, 
   3.872308219435268*^9}, {3.8723110787720003`*^9, 3.872311190330472*^9}, {
   3.872311837252905*^9, 3.872311866075659*^9}, {3.872311911945546*^9, 
   3.8723119125733147`*^9}, {3.872312000695552*^9, 3.872312005800097*^9}, {
   3.872314695075979*^9, 3.8723147748489523`*^9}, {3.8723148113004913`*^9, 
   3.872314814883875*^9}, {3.8775934484304*^9, 3.8775934938156433`*^9}, {
   3.8775935371783533`*^9, 3.877593543984405*^9}, {3.877594288705963*^9, 
   3.877594296203693*^9}, {3.8775943932772093`*^9, 3.8775944052791862`*^9}, {
   3.8776324511903963`*^9, 3.877632459295026*^9}, {3.87810343421664*^9, 
   3.87810343730319*^9}, {3.878103746532772*^9, 3.8781038157016897`*^9}, {
   3.878103978031775*^9, 3.878104024883812*^9}, {3.878104117764009*^9, 
   3.8781041925448647`*^9}, {3.8781042485347643`*^9, 3.87810432724249*^9}, {
   3.878104630653255*^9, 3.878104639939995*^9}, {3.8781046798564653`*^9, 
   3.878104680460561*^9}, 3.878106278397716*^9, {3.8926214835807247`*^9, 
   3.8926214900619507`*^9}, {3.8926221638097057`*^9, 3.892622167864273*^9}, {
   3.8926221993806133`*^9, 3.892622200288813*^9}, 3.892622251408462*^9, {
   3.892622358370657*^9, 3.89262238963063*^9}, {3.8926224387847233`*^9, 
   3.892622448800242*^9}, {3.8926318873416653`*^9, 3.892631940697077*^9}, {
   3.892631976850306*^9, 3.892631994705852*^9}, {3.892633463726879*^9, 
   3.892633566748089*^9}, {3.892633624019951*^9, 3.892633637300336*^9}, {
   3.892633844182879*^9, 3.892633844903285*^9}, {3.8926343617638283`*^9, 
   3.892634366755146*^9}, {3.892634417581902*^9, 3.892634430060636*^9}, {
   3.892634476036807*^9, 3.8926345520954313`*^9}, {3.8926346072403793`*^9, 
   3.892634614151228*^9}, {3.892634661078931*^9, 3.892634661589163*^9}, {
   3.892639060295385*^9, 3.892639103036963*^9}, {3.892639775455368*^9, 
   3.892639816070135*^9}, {3.8926399047786627`*^9, 3.892639965185875*^9}, {
   3.892640001240456*^9, 3.892640044037961*^9}, {3.892640079602545*^9, 
   3.892640103436265*^9}, {3.8926403341792507`*^9, 3.89264037239157*^9}, {
   3.8926404858632298`*^9, 3.892640488948964*^9}, {3.892640745125821*^9, 
   3.892640769284729*^9}, {3.8926408144428387`*^9, 3.892640844661614*^9}, {
   3.892640904105666*^9, 3.8926409051986856`*^9}, {3.892640955276992*^9, 
   3.8926409966466923`*^9}, {3.892641044533464*^9, 3.892641149526072*^9}, {
   3.892641220282558*^9, 3.892641226873201*^9}, {3.892641273929757*^9, 
   3.892641276212679*^9}, {3.8926416646842546`*^9, 3.8926416801368217`*^9}, {
   3.892641712463612*^9, 3.892641771671925*^9}, {3.892641816777886*^9, 
   3.892641839494503*^9}, {3.8926418768522387`*^9, 3.892641931808571*^9}, {
   3.8926420772292843`*^9, 3.8926421120987377`*^9}, {3.892642152856152*^9, 
   3.8926421541947803`*^9}, 3.8926421902332373`*^9, {3.8926422584227753`*^9, 
   3.892642259297017*^9}, {3.892642639197955*^9, 3.892642652372637*^9}, {
   3.8926427605935183`*^9, 3.8926427914137573`*^9}, {3.892642913952929*^9, 
   3.8926429182561283`*^9}, {3.892643109689077*^9, 3.89264312586768*^9}, {
   3.892643183017441*^9, 3.8926431860775433`*^9}, {3.892643273329484*^9, 
   3.89264327376297*^9}, {3.892643328032333*^9, 3.892643344432713*^9}, {
   3.8926467115905523`*^9, 3.8926467394837627`*^9}, {3.892647019311049*^9, 
   3.892647058518208*^9}, {3.892647411922245*^9, 3.8926474129935417`*^9}, {
   3.892647757387368*^9, 3.892647758347022*^9}, {3.8926523776364927`*^9, 
   3.892652395591152*^9}, {3.892652531330966*^9, 3.8926525354827003`*^9}, {
   3.8926525752677193`*^9, 3.892652618789791*^9}, {3.892652688839972*^9, 
   3.892652786533999*^9}, {3.8926529519283113`*^9, 3.8926529863523893`*^9}, {
   3.8926530462084293`*^9, 3.892653114459009*^9}, {3.8926531547609997`*^9, 
   3.892653159222917*^9}, {3.89265798321843*^9, 3.89265802423698*^9}, {
   3.892659237021781*^9, 3.892659238364017*^9}, 3.8926596833554296`*^9, {
   3.8926985357751913`*^9, 3.892698542917635*^9}, {3.892698673620758*^9, 
   3.892698793710672*^9}, {3.892699582552752*^9, 3.8926996900810003`*^9}, {
   3.8926997816995564`*^9, 3.8926997935013742`*^9}, {3.8927002915974913`*^9, 
   3.8927003202223377`*^9}, {3.892703090830639*^9, 3.8927031083338003`*^9}, {
   3.892703226970647*^9, 3.8927032274886503`*^9}, {3.892703290528536*^9, 
   3.8927034091282873`*^9}, {3.892703592695788*^9, 3.892703600159843*^9}, {
   3.8927066642531023`*^9, 3.892706666731621*^9}, {3.892713519987102*^9, 
   3.892713524618663*^9}, {3.892885561323964*^9, 3.8928855686738033`*^9}, 
   3.892885623242805*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"b2c8cf28-99dc-471a-8b3d-93d6968a90a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21474.274262`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.892903319395735*^9, 3.8929488195218897`*^9, 
  3.893266549586508*^9, 3.893309254802205*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"848c1b57-06b6-49fb-99e5-505db5e371cf"]
}, Open  ]]
}, Open  ]],

Cell["Timings: 21409.1,", "Text",
 CellChangeTimes->{{3.892909123826071*^9, 3.8929091363402557`*^9}, {
  3.8932936712664948`*^9, 
  3.893293674951179*^9}},ExpressionUUID->"367d6cf0-55d1-4ab0-9dd7-\
df0db03c97b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sortedRuns", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{"Counts", ",", "#"}], "]"}], "//", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{"KeySort", ",", "#"}], "]"}], "&"}]}], "//", "Counts"}], 
         "//", 
         RowBox[{
          RowBox[{"KeySortBy", "[", 
           RowBox[{"#", ",", 
            RowBox[{
             RowBox[{"Lookup", "[", 
              RowBox[{"#", ",", 
               RowBox[{"Key", "@", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ",", 
               "0"}], "]"}], "&"}]}], "]"}], "&"}]}], "//", "Reverse"}], 
       ")"}], "&"}], ",", 
     RowBox[{"Association", "@", "runs"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.892643092454713*^9, 3.892643092903453*^9}, {
  3.8926469513722267`*^9, 3.8926469823746567`*^9}, {3.89270284061419*^9, 
  3.8927029078901863`*^9}, {3.892702957583229*^9, 3.892702974249229*^9}, {
  3.892703011429521*^9, 3.892703035744937*^9}, {3.892703097642902*^9, 
  3.892703101827944*^9}, {3.892703449527666*^9, 3.892703531139222*^9}, {
  3.892703561646495*^9, 3.892703580036158*^9}, {3.892713493374989*^9, 
  3.892713505160966*^9}, {3.8927383802041273`*^9, 3.8927384021034203`*^9}, {
  3.892738452293776*^9, 3.8927384565646057`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"5415e875-b999-499c-929e-b89e3797644c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1593, 847},
WindowMargins->{{Automatic, 0}, {0, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>1.5 Inherited,
FrontEndVersion->"13.2 for Mac OS X ARM (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"89dd76db-db21-4ccb-b759-08a74ceefb00"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 800, 16, 185, "Title",ExpressionUUID->"bcd3c995-0cc1-4a17-bbbb-3a732f1bacde"],
Cell[1383, 40, 1594, 25, 189, "Text",ExpressionUUID->"4d69d43d-fca1-4c9f-b4de-bc7c9c8ddb12"],
Cell[2980, 67, 787, 16, 134, "Input",ExpressionUUID->"9ffd75ab-68ca-421a-8eba-4c022a1bd3ec"],
Cell[CellGroupData[{
Cell[3792, 87, 304, 4, 126, "Section",ExpressionUUID->"e4431d5b-799b-40cd-89da-495df9619242"],
Cell[4099, 93, 570, 11, 55, "Input",ExpressionUUID->"07259698-ce42-481a-baae-128f16fcde68"],
Cell[CellGroupData[{
Cell[4694, 108, 182, 2, 55, "Input",ExpressionUUID->"b1262ebf-6e0a-4983-8bcb-4a655a305a0a"],
Cell[4879, 112, 1641, 27, 181, "Output",ExpressionUUID->"f036917b-d526-442f-b72c-68e57756a9a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6557, 144, 285, 4, 55, "Input",ExpressionUUID->"3b8fc3ea-e203-41e6-ad3a-743159983f76"],
Cell[6845, 150, 2281, 55, 181, "Output",ExpressionUUID->"5e25851d-7963-485b-93b5-434c7746b557"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9163, 210, 212, 3, 55, "Input",ExpressionUUID->"bd421011-0606-4dfc-9ca4-d6d0aab68c16"],
Cell[9378, 215, 775, 13, 63, "Output",ExpressionUUID->"bbc72ee6-97c3-42a2-ae1a-ee01991e6d92"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10202, 234, 177, 3, 126, "Section",ExpressionUUID->"974e8ac3-7766-4380-b0c0-8ee12711fd4a"],
Cell[10382, 239, 226, 5, 64, "Text",ExpressionUUID->"2547b084-d74c-4178-834e-2fb4403340ce"],
Cell[CellGroupData[{
Cell[10633, 248, 1511, 38, 212, "Input",ExpressionUUID->"34aeda70-3d0d-48e8-b705-5bddbf3e8497"],
Cell[12147, 288, 624, 9, 63, "Output",ExpressionUUID->"67b7c5b8-04bc-4d5f-ac6e-c67ea75e1192"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12808, 302, 205, 3, 84, "Subsubsection",ExpressionUUID->"c195a4fa-9f2f-4360-879f-a2faf7fcdb35"],
Cell[CellGroupData[{
Cell[13038, 309, 238, 4, 60, "Item",ExpressionUUID->"5e921a0c-4f74-442c-9389-6cf257ab0336"],
Cell[CellGroupData[{
Cell[13301, 317, 17148, 321, 2084, "Input",ExpressionUUID->"b2c8cf28-99dc-471a-8b3d-93d6968a90a3"],
Cell[30452, 640, 280, 5, 63, "Output",ExpressionUUID->"848c1b57-06b6-49fb-99e5-505db5e371cf"]
}, Open  ]]
}, Open  ]],
Cell[30759, 649, 212, 4, 64, "Text",ExpressionUUID->"367d6cf0-55d1-4ab0-9dd7-df0db03c97b4"],
Cell[30974, 655, 1558, 37, 173, "Input",ExpressionUUID->"5415e875-b999-499c-929e-b89e3797644c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

