(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79023,       2041]
NotebookOptionsPosition[     74154,       1964]
NotebookOutlinePosition[     74551,       1980]
CellTagsIndexPosition[     74508,       1977]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Code", "Section",
 CellChangeTimes->{{3.8773373871413183`*^9, 
  3.8773373880561733`*^9}},ExpressionUUID->"a7b4ed64-894b-4ded-8663-\
31b37972111e"],

Cell[CellGroupData[{

Cell["Data", "Subsection",
 CellChangeTimes->{{3.8926188272840767`*^9, 
  3.892618827633625*^9}},ExpressionUUID->"0fce8476-a711-4e80-a4f3-\
54dea8b20405"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "ImportPennMLBenchmarksDataset", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImportPennMLBenchmarksDataset", "[", "datasetName_String", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"filename", ",", " ", "tsvHeader", ",", " ", "benchmarkData"}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"filename", "=", 
      RowBox[{
      "\"\<https://github.com/EpistasisLab/penn-ml-benchmarks/blob/master/\
datasets/\>\"", "<>", "datasetName", "<>", "\"\</\>\"", "<>", "datasetName", 
       "<>", "\"\<.tsv.gz?raw=true\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tsvHeader", "=", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{"filename", ",", "\"\<TSV\>\""}], "]"}], "//", "First"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"benchmarkData", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Import", "[", 
          RowBox[{"filename", ",", "\"\<TSV\>\""}], "]"}], "//", "Rest"}], "//", 
        RowBox[{
         RowBox[{"GroupBy", "[", 
          RowBox[{"#", ",", "Last"}], "]"}], "&"}]}], "//", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"Most", ",", "#", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"tsvHeader", ",", " ", "benchmarkData"}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.87050536091565*^9, 3.870505372873103*^9}, {
  3.870528853078041*^9, 3.870529008255496*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f0467122-ca6f-4e75-88d0-b126ee0d7b96"],

Cell["\<\
Mathematica\[CloseCurlyQuote]s Classify function is sometimes confused on \
what data types to use for feature values. This list specifies the type.\
\>", "Text",
 CellChangeTimes->{{3.89261896952969*^9, 
  3.892619024266006*^9}},ExpressionUUID->"dd19b2d7-0b02-49c2-b0ee-\
fa49b3799569"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uciAdultFeatures", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"11", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"14", ",", "\"\<Nominal\>\""}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8705322668290777`*^9, 3.870532304108699*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"baa656de-5c12-4d7f-b1b5-3eeb88a462d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "\<\"Nominal\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.892619032450945*^9, 3.892620272413516*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"b8f65592-a993-4002-9d8d-4397c804ea42"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"mushroomFeatures", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"11", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"14", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"15", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"17", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"18", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"19", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"21", ",", "\"\<Nominal\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"22", ",", "\"\<Nominal\>\""}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"df5a980b-036d-4797-b390-8cfa1a0721b9"],

Cell[BoxData[
 RowBox[{"twonormFeatures", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"11", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"14", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"15", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"17", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"18", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"19", ",", "\"\<Numerical\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "\"\<Numerical\>\""}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.893143973402233*^9, 3.893143979460854*^9}, 
   3.8931440394543457`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"c3e11402-339f-4cc6-92d4-55c952bac78b"]
}, Open  ]],

Cell["Data sketch", "Subsection",
 CellChangeTimes->{{3.892619879654242*^9, 
  3.892619898759454*^9}},ExpressionUUID->"bbeac00d-d4e6-4715-912b-\
654f423e550c"],

Cell[CellGroupData[{

Cell["True or Ground Truth Evaluation Point", "Subsection",
 CellChangeTimes->{{3.8926199656557903`*^9, 
  3.8926199819214993`*^9}},ExpressionUUID->"5e44984e-20a3-4891-9c1c-\
d98bcc7f3308"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "VotingFrequenciesData", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VotingFrequenciesData", "[", 
   RowBox[{"testAlignedDecisions_Association", ",", 
    RowBox[{"classifiers", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ".."}], "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "eventCounts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"eventCounts", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Values", "@", "testAlignedDecisions"}], "//", 
             RowBox[{
              RowBox[{"Merge", "[", 
               RowBox[{"#", ",", "Identity"}], "]"}], "&"}]}], "//", 
            RowBox[{
             RowBox[{"Map", "[", 
              RowBox[{"Total", ",", "#"}], "]"}], "&"}]}], "//", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"KeyValueMap", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "classifiers", "]"}], "]"}], "\[Rule]", "#2"}],
                 ")"}], "&"}], ",", "#"}], "]"}], "&"}]}], "//", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"GroupBy", "[", 
            RowBox[{"#", ",", "First"}], "]"}], "&"}]}], "//", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Map", "[", 
           RowBox[{"Last", ",", "#", ",", 
            RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{"Total", ",", "#"}], "]"}], "&"}]}], "//", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"KeyMap", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Subscript", "[", 
            RowBox[{"f", ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"#", "\[Equal]", "0"}], ",", "\[Alpha]", ",", 
                   "\[Beta]"}], "]"}], "&"}], ",", "#"}], "]"}]}]}], "]"}], 
           "&"}], ",", "#"}], "]"}], "&"}]}], "//", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"#", "/", 
        RowBox[{"Total", "@", "#"}]}], "&"}]}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.870534342005334*^9, 3.870534342670374*^9}, {
  3.870534561944002*^9, 3.870534574830029*^9}, {3.870534618654681*^9, 
  3.870534619623879*^9}, {3.87053465009134*^9, 3.870534665477736*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"cb26d95a-553b-423c-91bc-b23a034cda23"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "TurnVotesToIndicators", "]"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{"TurnVotesToIndicators", "[", 
    RowBox[{"key_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "===", "label"}], ",", "1", ",", "0"}], "]"}], "&"}], 
     ",", "key"}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "ClassifierLabelAccuracy", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClassifierLabelAccuracy", "[", 
   RowBox[{
   "voteCountsByLabel_Association", ",", " ", "classifier_Integer", ",", " ", 
    "label_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"voteCountsByLabel", "[", "label", "]"}], "//", 
        RowBox[{
         RowBox[{"KeyMap", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TurnVotesToIndicators", "[", 
             RowBox[{"#", ",", "label"}], "]"}], "&"}], ",", "#"}], "]"}], 
         "&"}]}], "//", "Normal"}], " ", "//", 
      RowBox[{
       RowBox[{"GroupBy", "[", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "classifier"}], "]"}], "]"}], "&"}]}], "]"}], 
       "&"}]}], "//", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"Last", ",", "#", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Total", ",", "#"}], "]"}], "&"}]}], "//", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", "1", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"Total", "@", "#"}], ")"}]}], "&"}], " "}]}]}], "Input",
 CellChangeTimes->{3.8713800039501667`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"88dcf551-eb5d-41a0-ae20-86fd5ce02d5a"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "ProjectVoteCounts", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProjectVoteCounts", "[", 
   RowBox[{"labelVoteCounts_", ",", "classifiers_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Normal", "[", "labelVoteCounts", "]"}], "//", " ", 
     RowBox[{
      RowBox[{"GroupBy", "[", 
       RowBox[{"#", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "classifiers"}], "]"}], "]"}], "&"}]}], "]"}], 
      "&"}]}], "//", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", "#", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"Total", ",", "#"}], "]"}], "&"}]}]}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"2d96dd7c-ceb3-4750-b28f-c965708c8dd2"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "CorrelationProduct", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CorrelationProduct", "[", 
     RowBox[{"indicators_List", ",", "accuracies_List"}], "]"}], ":=", 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      RowBox[{"indicators", "-", "accuracies"}], ")"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "LabelCorrelations", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LabelCorrelations", "[", 
     RowBox[{
     "voteCountsByLabel_Association", ",", "classifiers_List", ",", 
      "label_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"Module", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "labelAccuracies", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"labelAccuracies", " ", "=", " ", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ClassifierLabelAccuracy", "[", 
              RowBox[{"voteCountsByLabel", ",", "#", ",", "label"}], "]"}], 
             "&"}], ",", "classifiers"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"voteCountsByLabel", "[", "label", "]"}], "//", 
            RowBox[{
             RowBox[{"ProjectVoteCounts", "[", 
              RowBox[{"#", ",", "classifiers"}], "]"}], "&"}]}], " ", "//", 
           RowBox[{
            RowBox[{"KeyMap", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TurnVotesToIndicators", "[", 
                RowBox[{"#", ",", "label"}], "]"}], "&"}], ",", "#"}], "]"}], 
            "&"}]}], "//", 
          RowBox[{
           RowBox[{"KeyMap", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"CorrelationProduct", "[", 
               RowBox[{"#", ",", "labelAccuracies"}], "]"}], "&"}], ",", 
             "#"}], "]"}], "&"}]}]}]}], " ", "]"}], "//", "Normal"}], "//", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Times", "@@", "#"}], "&"}], ",", "#"}], "]"}], "//", 
          "Total"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Map", "[", 
           RowBox[{"Last", ",", "#"}], "]"}], "//", "Total"}], ")"}]}], ")"}],
       "&"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.836634754353052*^9, 3.836634798922491*^9}, {
   3.836635530523657*^9, 3.836635587067238*^9}, {3.836635758240337*^9, 
   3.8366358740932903`*^9}, {3.836635967256659*^9, 3.836636035151163*^9}, {
   3.836636090705647*^9, 3.836636096104578*^9}, {3.836636246345263*^9, 
   3.836636250493054*^9}, {3.8366367496921577`*^9, 3.836636883636326*^9}, {
   3.836636917297247*^9, 3.836637049745595*^9}, {3.8366373887690983`*^9, 
   3.836637413564143*^9}, {3.83663763564142*^9, 3.8366377392131844`*^9}, {
   3.836637817706025*^9, 3.8366378184451637`*^9}, {3.836637887648898*^9, 
   3.836637906481523*^9}, {3.836638095370552*^9, 3.83663812975146*^9}, {
   3.8366381698255863`*^9, 3.836638274815072*^9}, {3.8366383121308193`*^9, 
   3.836638368788406*^9}, {3.836638402425725*^9, 3.8366384999636497`*^9}, {
   3.836638536755376*^9, 3.836638629747478*^9}, 3.870533735561873*^9, 
   3.8705337745738897`*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"5ffe11ec-2c43-4a1c-92fd-7922dbfc94fd"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "GTClassifiers", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "GTClassifiers", "[", "votingPatternCountsByLabel_Association", "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"alphaLabel", "=", "0"}], ",", "nClassifiers"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"nClassifiers", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"votingPatternCountsByLabel", "//", "First"}], "//", 
         "Keys"}], "//", "RandomChoice"}], "//", "Length"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["P", "\[Alpha]"], "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"votingPatternCountsByLabel", "//", 
              RowBox[{
               RowBox[{"Map", "[", 
                RowBox[{"Values", ",", "#"}], "]"}], "&"}]}], "//", 
             RowBox[{
              RowBox[{"Map", "[", 
               RowBox[{"Total", ",", "#"}], "]"}], "&"}]}], "//", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", "alphaLabel", "]"}], "/", 
              RowBox[{"Total", "@", "#"}]}], "&"}]}], ")"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["P", 
            RowBox[{"i", ",", "\[Alpha]"}]], "->", 
           RowBox[{"ClassifierLabelAccuracy", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "i", ",", "0"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "nClassifiers"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["P", 
            RowBox[{"i", ",", "\[Beta]"}]], "->", 
           RowBox[{"ClassifierLabelAccuracy", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "i", ",", "1"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "nClassifiers"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{
             RowBox[{"Sequence", "@@", "pair"}], ",", "\[Alpha]"}]], "->", 
           RowBox[{"LabelCorrelations", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "pair", ",", "0"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"pair", ",", 
            RowBox[{"Subsets", "[", 
             RowBox[{
              RowBox[{"Range", "@", "nClassifiers"}], ",", 
              RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{
             RowBox[{"Sequence", "@@", "pair"}], ",", "\[Beta]"}]], "->", 
           RowBox[{"LabelCorrelations", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "pair", ",", "1"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"pair", ",", 
            RowBox[{"Subsets", "[", 
             RowBox[{
              RowBox[{"Range", "@", "nClassifiers"}], ",", 
              RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{
             RowBox[{"Sequence", "@@", "trio"}], ",", "\[Alpha]"}]], "->", 
           RowBox[{"LabelCorrelations", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "trio", ",", "0"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"trio", ",", 
            RowBox[{"Subsets", "[", 
             RowBox[{
              RowBox[{"Range", "@", "nClassifiers"}], ",", 
              RowBox[{"{", "3", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{
             RowBox[{"Sequence", "@@", "trio"}], ",", "\[Beta]"}]], "->", 
           RowBox[{"LabelCorrelations", "[", 
            RowBox[{"votingPatternCountsByLabel", ",", "trio", ",", "1"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"trio", ",", 
            RowBox[{"Subsets", "[", 
             RowBox[{
              RowBox[{"Range", "@", "nClassifiers"}], ",", 
              RowBox[{"{", "3", "}"}]}], "]"}]}], "}"}]}], "]"}]}], "]"}], "//",
       "Association"}]}]}], "\[IndentingNewLine]", " ", "]"}]}]}], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"53ab4a81-9b4a-4340-8ba1-543cee642e3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra", "Subsection",
 CellChangeTimes->{{3.892618602133133*^9, 
  3.892618603536901*^9}},ExpressionUUID->"87d37b3d-8d48-4698-9db1-\
c2fe89182e67"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "IndependentGeneratingSet", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IndependentGeneratingSet", "[", 
   RowBox[{"{", 
    RowBox[{"i_", ",", "j_", ",", "k_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Alpha]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Alpha]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Alpha]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Alpha]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Alpha]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Alpha]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Beta]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Alpha]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Alpha]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Beta]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", 
         RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["P", "\[Alpha]"]}], ")"}], " ", 
      SubscriptBox["P", 
       RowBox[{"i", ",", "\[Beta]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"j", ",", "\[Beta]"}]], " ", 
      SubscriptBox["P", 
       RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
     SubscriptBox["f", 
      RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}]}], 
   "}"}]}]}], "Input",
 CellChangeTimes->{{3.8926325118872004`*^9, 3.892632574313819*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"eb2aee6a-083b-46d5-ae4f-257222765dda"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "AlgebraicallyEvaluateClassifiers", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AlgebraicallyEvaluateClassifiers", "[", "vcbl_", "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
     "evaluationIdeal", ",", "\[IndentingNewLine]", "equationsToSolve", ",", 
      "vars", ",", " ", "sols", ",", "gt", ",", "observableFrequencies"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Calculate", " ", "the", " ", "size", " ", "of", " ", "the", " ", "test",
       " ", "sets"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"observableFrequencies", "=", 
      RowBox[{"VotingFrequenciesData", "[", 
       RowBox[{"vcbl", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"evaluationIdeal", "=", 
      RowBox[{"IndependentGeneratingSet", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"equationsToSolve", "=", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"#", "\[Equal]", "0"}], ")"}], "&"}], ",", 
         "evaluationIdeal"}], "]"}], "/.", "observableFrequencies"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"vars", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Variables", "/@", "evaluationIdeal"}], "//", "Flatten"}], "//",
         "DeleteDuplicates"}], "//", 
       RowBox[{
        RowBox[{"SortBy", "[", 
         RowBox[{"#", ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Last", "@", "#"}], "}"}], "&"}]}], "]"}], "&"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{"equationsToSolve", ",", "vars"}], "]"}]}]}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.870579338431823*^9, 3.870579347665485*^9}, {
   3.8713799381836452`*^9, 3.871379939607839*^9}, {3.8716408380619507`*^9, 
   3.871640897246999*^9}, {3.871640965941798*^9, 3.8716409830563087`*^9}, {
   3.871641459299225*^9, 3.87164146009029*^9}, 3.871641533002849*^9, {
   3.87166007285585*^9, 3.871660099185485*^9}, {3.871660194942624*^9, 
   3.8716602583051662`*^9}, {3.8717024073766947`*^9, 
   3.8717024077468033`*^9}, {3.87196632901931*^9, 3.8719663309593973`*^9}, {
   3.8719663806881523`*^9, 3.871966382909005*^9}, 3.871966418706856*^9, {
   3.871966500261044*^9, 3.871966505146159*^9}, {3.871966596828096*^9, 
   3.871966607987453*^9}, {3.8719666514559927`*^9, 3.87196670911133*^9}, {
   3.8926326114450493`*^9, 3.892632614919393*^9}, {3.892699055224489*^9, 
   3.892699169863109*^9}, {3.892699201519285*^9, 3.892699204049711*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"40e77f3c-1bda-4311-a481-2d585770f817"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "FirstSolutionPoint", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FirstSolutionPoint", "[", "eval_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Last", "@", "eval"}], "//", "First"}], "//", "First"}], "//", 
   "Association"}]}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "SecondSolutionPoint", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SecondSolutionPoint", "[", "eval_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Last", "@", "eval"}], "//", "First"}], "//", "Last"}], "//", 
   "Association"}]}]}], "Input",
 CellChangeTimes->{{3.872228337899802*^9, 3.87222835234769*^9}, {
  3.8722283897527018`*^9, 3.872228414611442*^9}, {3.87222851846124*^9, 
  3.872228583595087*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"c0276646-a518-4bd0-aadb-7d7fbbc12697"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "GroundTruthCoordinates", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GroundTruthCoordinates", "[", "point_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "\[Alpha]"], ",", 
     SubscriptBox["P", 
      RowBox[{"1", ",", "\[Alpha]"}]], ",", 
     SubscriptBox["P", 
      RowBox[{"1", ",", "\[Beta]"}]], ",", 
     SubscriptBox["P", 
      RowBox[{"2", ",", "\[Alpha]"}]], ",", 
     SubscriptBox["P", 
      RowBox[{"2", ",", "\[Beta]"}]], ",", 
     SubscriptBox["P", 
      RowBox[{"3", ",", "\[Alpha]"}]], ",", 
     SubscriptBox["P", 
      RowBox[{"3", ",", "\[Beta]"}]]}], "}"}], "/.", "point"}]}]}], "Input",
 CellChangeTimes->{{3.872228659683131*^9, 3.872228789566605*^9}, {
  3.893217983952456*^9, 3.893217985948863*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"754393f6-e7e7-46f6-9efd-77ef77dbcf54"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "IsNotComplexQ", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IsNotComplexQ", "[", "eval_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"eval", "//", "Last"}], "//", "Flatten"}], "//", 
    RowBox[{
     RowBox[{"Last", "/@", "#"}], "&"}]}], "//", 
   RowBox[{
    RowBox[{"Not", "@", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"#", ",", "_Complex", ",", "Infinity"}], "]"}]}], 
    "&"}]}]}]}], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"e362c9ac-04ca-49d6-815f-15f57c490756"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "MetricVsDistance", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MetricVsDistance", "[", 
   RowBox[{"featuresRunEval_List", ",", "metric_"}], "]"}], ":=", 
  RowBox[{"featuresRunEval", "//", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"(*", " ", 
      RowBox[{
      "we", " ", "want", " ", "the", " ", "ground", " ", "truth", " ", 
       "evaluation"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"First", "@", 
        RowBox[{"First", "@", "#"}]}], "//", "\[IndentingNewLine]", 
       "metric"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Last", "@", "#"}]}], "}"}], "&"}]}]}]}], "Input",
 CellChangeTimes->{{3.878188344856113*^9, 3.878188524273679*^9}, {
  3.878188599311413*^9, 3.878188658093204*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"64ee429e-4fbd-4bfa-a4b4-89985c08a17e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic evaluation failure mode tests", "Subsection",
 CellChangeTimes->{{3.892632020311818*^9, 3.892632023586937*^9}, {
  3.892632145465925*^9, 
  3.892632161081513*^9}},ExpressionUUID->"d3d8b6d4-61ba-452a-81fe-\
fd83cd6d8a50"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "independent", " ", "evaluation", " ", "ideal", " ", "may", 
    " ", "be", " ", "empty"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "HasAllDecisionFrequenciesQ", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HasAllDecisionFrequenciesQ", "[", "voteCountsByLabel_", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "observableFrequencies", ",", " ", "evaluationGS", ",", " ", 
        "empiricalSet"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"observableFrequencies", "=", 
        RowBox[{"VotingFrequenciesData", "[", 
         RowBox[{"voteCountsByLabel", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"observableFrequencies", "//", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "@", "#"}], "==", "8"}], ",", "True", ",", 
           "False"}], "]"}], "&"}]}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.892632885349122*^9, 3.892632960162901*^9}, {
  3.892643222328236*^9, 3.8926432337716217`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"8c0f2858-f80f-4371-a763-b22a07943a30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "independent", " ", "evaluation", " ", "ideal", " ", "may", 
    " ", "be", " ", "empty"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "IndependentEvaluationIdealIsNonEmptyQ", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "IndependentEvaluationIdealIsNonEmptyQ", "[", "voteCountsByLabel_", "]"}],
     ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "observableFrequencies", ",", "\[IndentingNewLine]", " ", 
        "evaluationGS", ",", "\[IndentingNewLine]", "observedGS", ",", 
        "\[IndentingNewLine]", " ", "vars", ",", "\[IndentingNewLine]", 
        "gb"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Set", "-", 
        RowBox[{
        "up", " ", "the", " ", "generating", " ", "set", " ", "from", " ", 
         "the", " ", "decisions", " ", "data", " ", "sketch"}]}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"observableFrequencies", "=", 
        RowBox[{"VotingFrequenciesData", "[", 
         RowBox[{"voteCountsByLabel", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"evaluationGS", "=", 
        RowBox[{"IndependentGeneratingSet", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"observedGS", "=", 
        RowBox[{"evaluationGS", "/.", "observableFrequencies"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"vars", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Variables", "@", "observedGS"}], "//", 
          "DeleteDuplicates"}], "//", 
         RowBox[{
          RowBox[{"SortBy", "[", 
           RowBox[{"#", ",", "Last"}], "]"}], "&"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Does", " ", "this", " ", "generating", " ", "set", " ", "have", " ", 
         "a", " ", "Groebner", " ", "basis"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"gb", "=", 
        RowBox[{"GroebnerBasis", "[", 
         RowBox[{"observedGS", ",", 
          RowBox[{"Reverse", "@", "vars"}], ",", 
          RowBox[{"CoefficientDomain", "->", "Rationals"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"gb", "==", 
          RowBox[{"{", "1", "}"}]}], ",", "False", ",", "True"}], "]"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8926320274649897`*^9, 3.8926320746289577`*^9}, {
   3.892632109431039*^9, 3.892632116822913*^9}, {3.8926322383904*^9, 
   3.8926322846451197`*^9}, {3.8926323773623133`*^9, 3.892632412027067*^9}, {
   3.8926324493813066`*^9, 3.892632498272028*^9}, {3.892632673354898*^9, 
   3.892632806339404*^9}, 3.892632896295476*^9, {3.892643250254636*^9, 
   3.892643255869706*^9}, {3.892650676427417*^9, 3.8926509275826674`*^9}, {
   3.892657321747383*^9, 3.892657354098021*^9}, {3.892657414810822*^9, 
   3.892657459576704*^9}, 3.892657580555222*^9, {3.892657615982514*^9, 
   3.892657669138886*^9}, {3.892657732446699*^9, 3.892657745458334*^9}, {
   3.892657913873226*^9, 3.892657965114649*^9}, {3.892658038524426*^9, 
   3.892658038893162*^9}, {3.892701813599597*^9, 3.892701829873783*^9}, {
   3.89270201874988*^9, 3.89270202002103*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"4b60f1e3-3970-44b8-bbe7-5984feef9719"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "independent", " ", "estimates", " ", "may", " ", "contain", 
    " ", "complex", " ", "numbers"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "HasOnlyRealNumbersQ", "]"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"HasOnlyRealNumbersQ", "[", "sols_List", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"First", "@", "sols"}], "//", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Last", "/@", "#"}], "&"}]}], "//", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"#", ",", "Complex", ",", " ", 
        RowBox[{"Heads", "->", "True"}]}], "]"}], "&"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.8926983741511173`*^9, 3.892698471623551*^9}, {
  3.8926989522890778`*^9, 3.892698959450789*^9}, {3.892699256867969*^9, 
  3.8926992641165*^9}, {3.892699294149352*^9, 3.892699382043692*^9}, {
  3.892700085954612*^9, 3.892700112846019*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"fe8427ad-700f-423c-932b-fa92d7c152cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "independent", " ", "estimates", " ", "may", " ", "be", " ", 
    "outside", " ", "the", " ", "unit", " ", "cube"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "InsideUnitCubeQ", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"InsideUnitCubeQ", "[", "sols_List", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"First", "@", "sols"}], "//", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Last", "/@", "#"}], "&"}]}], "//", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", ">", "0"}], " ", "&&", " ", 
             RowBox[{"#", "<", "1"}]}], ")"}], "&"}], ",", "#"}], "]"}], 
        "&"}]}], "//", "\[IndentingNewLine]", "Counts"}], "//", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Lookup", "[", 
          RowBox[{"#", ",", "False", ",", "0"}], "]"}], ">", "0"}], ",", 
        "False", ",", "True"}], "]"}], "&"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.892699410824635*^9, 3.8926994588566523`*^9}, {
  3.892699524860627*^9, 3.8926995559164677`*^9}, {3.8926996348011723`*^9, 
  3.892699641630151*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"cd5d2c3a-bd4f-4d88-b476-c90b9f23f459"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Universal Surface in Accuracies+Prevalence Space", "Subsection",
 CellChangeTimes->{{3.8720489761894913`*^9, 
  3.8720490025813828`*^9}},ExpressionUUID->"d4a11728-5298-4492-99fe-\
3c6c096b16c2"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "GroundTruthImplicitRegion", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GroundTruthImplicitRegion", "[", 
   RowBox[{"voteCountsByLabel_Association", ",", " ", 
    RowBox[{"classifiers", ":", 
     RowBox[{"{", "__Integer", "}"}]}], ",", "label_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqs", ",", "vars", ",", "prevalence", ",", "prevalenceTerms"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eqs", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]], "-", 
            SubscriptBox["f", "\[Alpha]"]}], ",", 
           RowBox[{
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]], "-", 
            SubscriptBox["f", "\[Beta]"]}]}], "}"}], "/.", 
         RowBox[{"VotingFrequenciesData", "[", 
          RowBox[{"voteCountsByLabel", ",", 
           RowBox[{"{", "i", "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "classifiers"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"vars", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Flatten", "@", "eqs"}], "//", 
          RowBox[{
           RowBox[{"Variables", "/@", "#"}], "&"}]}], "//", "Flatten"}], "//",
         "DeleteDuplicates"}], "//", "Sort"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"prevalence", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"label", "==", "\[Alpha]"}], ",", 
        SubscriptBox["P", "\[Alpha]"], ",", 
        SubscriptBox["P", "\[Beta]"]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"prevalenceTerms", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"label", "==", "\[Alpha]"}], ",", 
        RowBox[{"{", 
         RowBox[{"prevalence", ",", 
          RowBox[{"1", "-", "prevalence"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "prevalence"}], ",", "prevalence"}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ImplicitRegion", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"The", " ", "single", " ", "classifier", " ", "equations"}], 
         " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Transpose", "@", 
               RowBox[{"{", 
                RowBox[{"prevalenceTerms", ",", "#"}], "}"}]}], "&"}], ",", 
             "eqs"}], "]"}], "//", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Times", "@@", "#"}], "&"}], ",", "#", ",", 
              RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"First", "@", "#"}], "-", 
                 RowBox[{"Last", "@", "#"}]}], "==", "0"}], ")"}], "&"}], ",",
              "#"}], "]"}], "&"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"The", " ", "pair", " ", "equations"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"eqs", "[", 
                RowBox[{"[", "pair", "]"}], "]"}], "//", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"First", "@", "#"}], ",", 
                  RowBox[{"Reverse", "@", 
                   RowBox[{"Last", "@", "#"}]}]}], "}"}], "&"}]}], "//", 
              "Transpose"}], "//", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Times", "@@", "#"}], "&"}], "/@", "#"}], "&"}]}], "//",
             "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"First", "@", "#"}], "-", 
                RowBox[{"Last", "@", "#"}]}], "==", "0"}], ")"}], "&"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"pair", ",", 
             RowBox[{"Subsets", "[", 
              RowBox[{"classifiers", ",", 
               RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]}], "]"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Evaluate", "@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"var", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"var", ",", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{"{", "prevalence", "}"}], ",", "vars"}], "]"}]}], 
           "}"}]}], "]"}]}]}], "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.872049015152226*^9, 3.872049060631426*^9}, {
   3.872049146296269*^9, 3.872049159189414*^9}, 3.872049207903535*^9, {
   3.872049593608644*^9, 3.8720496035744057`*^9}, {3.872049650254553*^9, 
   3.8720497696579237`*^9}, 3.872049869985826*^9, {3.872049933978451*^9, 
   3.872049937460208*^9}, {3.872049993494216*^9, 3.8720501703193483`*^9}, {
   3.8720502353329678`*^9, 3.872050338968964*^9}, {3.87205041574654*^9, 
   3.8720505040776863`*^9}, {3.872050543255834*^9, 3.872050776231328*^9}, {
   3.872050814466736*^9, 3.872050860859264*^9}, {3.87205091029771*^9, 
   3.872051033146644*^9}, {3.8720511562317877`*^9, 3.872051157836856*^9}, {
   3.8720514127607727`*^9, 3.872051443047064*^9}, {3.872051497640646*^9, 
   3.8720515629538517`*^9}, {3.8723072600391273`*^9, 3.87230734702037*^9}, {
   3.8744866444946404`*^9, 3.874486693746254*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"6209b446-8896-4cd9-9e5d-42cb49e9793e"],

Cell[CellGroupData[{

Cell["Experiments code", "Subsubsection",
 CellChangeTimes->{{3.893738684623522*^9, 
  3.89373868821551*^9}},ExpressionUUID->"7ebd56d7-8ad1-4998-8e72-\
66119ab20ca5"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "DistancesToCV", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DistancesToCV", "[", "partitionRuns_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Last", "@", "partitionRuns"}], "//", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GroundTruthImplicitRegion", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "\[Alpha]"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"AlgebraicallyEvaluateClassifiers", "@", "#"}], "//", 
            "First"}], "//", "N"}], "//", "GroundTruthCoordinates"}]}], "}"}],
        "&"}], "/@", "#"}], "&"}]}], "//", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RegionDistance", "[", 
        RowBox[{
         RowBox[{"First", "@", "#"}], ",", 
         RowBox[{"Last", "@", "#"}]}], "]"}], "&"}], ",", "#"}], "]"}], 
    "&"}]}]}]}], "Input",
 CellChangeTimes->{{3.89326518014192*^9, 3.8932652818524733`*^9}, {
   3.893265328900107*^9, 3.893265330073368*^9}, {3.893265361201034*^9, 
   3.893265517455163*^9}, 3.893265553257162*^9, {3.893265604949889*^9, 
   3.893265681909186*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"c94ec724-e769-48d9-a501-44f92d3127ad"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "TrueEvaluations2Way", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TrueEvaluations2Way", "[", "partitionRuns_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{"GTClassifiers", ",", 
         RowBox[{"Last", "@", "partitionRuns"}]}], "]"}], "//", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"KeySelect", "[", 
            RowBox[{"#", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"First", "@", "#"}], "==", "\[CapitalGamma]"}], "&&", 
                RowBox[{
                 RowBox[{"Length", "@", "#"}], "==", "4"}]}], ")"}], "&"}]}], 
            "]"}], "&"}], ",", "#"}], "]"}], "&"}]}], "//", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Values", "/@", "#"}], "&"}]}], "//", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SortBy", "[", 
          RowBox[{"#", ",", "Abs"}], "]"}], "&"}], ",", "#"}], "]"}], "&"}]}],
     "//", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Reverse", ",", "#"}], "]"}], "&"}]}], "//", 
   RowBox[{
    RowBox[{"First", "/@", "#"}], "&"}]}]}]}], "Input",
 CellChangeTimes->{{3.893265868045209*^9, 3.893265899608602*^9}, {
  3.893265962404212*^9, 3.893266008868943*^9}, {3.893266323643712*^9, 
  3.89326638812467*^9}, {3.893266423939271*^9, 3.893266430960071*^9}, {
  3.893266982998454*^9, 3.89326699967778*^9}, {3.893267095870693*^9, 
  3.8932671205191517`*^9}, {3.8932673029653807`*^9, 3.8932673280715113`*^9}, {
  3.893294390532343*^9, 3.893294397319623*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"40e43f9e-0d15-4bed-8298-424d14bba147"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "VCBLs", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VCBLs", "[", "partitionRuns_", "]"}], ":=", 
  RowBox[{"Last", "@", "partitionRuns"}]}]}], "Input",
 CellChangeTimes->{{3.893739159655253*^9, 3.893739161356474*^9}, {
  3.893739257292266*^9, 3.8937392796354637`*^9}, {3.893739377065572*^9, 
  3.893739383448423*^9}},ExpressionUUID->"41ff53cb-f49b-4646-b381-\
6f307b642c2b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Training ensembles", "Subsection",
 CellChangeTimes->{{3.892570515826088*^9, 
  3.8925705247015667`*^9}},ExpressionUUID->"9600e475-bf31-44e0-93cb-\
9a84c189e35c"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "MakeTrainTestSplit", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeTrainTestSplit", "[", 
   RowBox[{"data_Association", ",", 
    RowBox[{"aTrainIndices", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ".."}], "}"}]}], ",", 
    RowBox[{"bTrainIndices", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ".."}], "}"}]}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"aLength", ",", " ", "bLength"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"aLength", "=", 
      RowBox[{"Length", "@", 
       RowBox[{"data", "[", "0", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bLength", " ", "=", " ", 
      RowBox[{"Length", "@", 
       RowBox[{"data", "[", "1", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Association", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"0", "->", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"data", "[", "0", "]"}], "//", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "aTrainIndices", "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Range", "@", "aLength"}], ",", "aTrainIndices"}], 
                "]"}], "]"}], "]"}]}], "}"}], "&"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"1", "->", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"data", "[", "1", "]"}], "//", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "bTrainIndices", "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Range", "@", "bLength"}], ",", "bTrainIndices"}], 
                "]"}], "]"}], "]"}]}], "}"}], "&"}]}], ")"}]}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.892634021796659*^9, 3.892634182390811*^9}, {
  3.8926342349995613`*^9, 3.892634288202475*^9}, {3.892634442626688*^9, 
  3.892634465628072*^9}, {3.892634811306509*^9, 3.892635032510042*^9}, {
  3.8926389707319098`*^9, 3.892638981826263*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"f22d3a68-2983-4537-a563-2855d696d359"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "RandomSampleTrainTestSplit", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RandomSampleTrainTestSplit", "[", 
   RowBox[{"data_", ",", "nTestAlpha_Integer", ",", "nTrain_Integer"}], "]"}],
   ":=", "\[IndentingNewLine]", 
  RowBox[{"Association", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"0", "->", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"First", "@", 
          RowBox[{"data", "[", "0", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTrain"}], "]"}], "&"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"Last", "@", 
          RowBox[{"data", "[", "0", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTestAlpha"}], "]"}], "&"}]}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"1", "->", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"First", "@", 
          RowBox[{"data", "[", "1", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTrain"}], "]"}], "&"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"Last", "@", 
          RowBox[{"data", "[", "1", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", 
           RowBox[{"nTestAlpha", "//", "Floor"}]}], "]"}], "&"}]}]}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8722289851110153`*^9, 3.87222914171426*^9}, {
  3.872229202124264*^9, 3.872229210651655*^9}, {3.872229297089395*^9, 
  3.872229310311461*^9}, {3.872229390289608*^9, 3.872229583620008*^9}, {
  3.872342411597763*^9, 3.8723424285486393`*^9}, {3.872343118154087*^9, 
  3.872343131241008*^9}, {3.8773368188985777`*^9, 3.87733681924405*^9}, {
  3.8926394966747713`*^9, 3.892639510976342*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"53a30dd0-9474-4a08-a4b8-2a9855e0d68f"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "ClassifiersSampleIndices", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClassifiersSampleIndices", "[", 
   RowBox[{"data_", ",", " ", "nSample_Integer"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomSample", "[", 
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", "data"}]}], "]"}], "//", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{"#", ",", "nSample"}], "]"}], "&"}]}], "//", 
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"#", ",", "3"}], "]"}], "&"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "SampleIndices", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SampleIndices", "[", 
   RowBox[{"data_", ",", "nSample_Integer"}], "]"}], ":=", 
  RowBox[{"RandomSample", "[", 
   RowBox[{
    RowBox[{"Range", "@", 
     RowBox[{"Length", "@", "data"}]}], ",", "nSample"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.892640168578079*^9, 3.8926401695028343`*^9}, {
  3.892640207493516*^9, 3.892640309296302*^9}, {3.892642433480235*^9, 
  3.89264244640923*^9}, {3.892642542584735*^9, 3.892642609407044*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"060ba8ed-fda7-4b26-8327-4d4d94d03634"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "SelectTrainDataFromSplit", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SelectTrainDataFromSplit", "[", "data_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"First", ",", "data"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "SelectTestDataFromSplit", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SelectTestDataFromSplit", "[", "data_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"Last", ",", "data"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.892639518876965*^9, 3.892639628081006*^9}, {
  3.892639660206984*^9, 3.892639761473098*^9}, {3.892639844149186*^9, 
  3.892639846015081*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"25067183-bb4f-439a-b130-a2be6a336e14"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "SelectFromTrainTestSplit", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SelectFromTrainTestSplit", "[", 
   RowBox[{"data_", ",", "nTestAlpha_Integer", ",", "nTrain_Integer"}], "]"}],
   ":=", "\[IndentingNewLine]", 
  RowBox[{"Association", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"0", "->", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"First", "@", 
          RowBox[{"data", "[", "0", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTrain"}], "]"}], "&"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"Last", "@", 
          RowBox[{"data", "[", "0", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTestAlpha"}], "]"}], "&"}]}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"1", "->", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"First", "@", 
          RowBox[{"data", "[", "1", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "nTrain"}], "]"}], "&"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RandomSample", "[", 
         RowBox[{"Last", "@", 
          RowBox[{"data", "[", "1", "]"}]}], "]"}], "//", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", 
           RowBox[{"nTestAlpha", "//", "Floor"}]}], "]"}], "&"}]}]}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8722289851110153`*^9, 3.87222914171426*^9}, {
  3.872229202124264*^9, 3.872229210651655*^9}, {3.872229297089395*^9, 
  3.872229310311461*^9}, {3.872229390289608*^9, 3.872229583620008*^9}, {
  3.872342411597763*^9, 3.8723424285486393`*^9}, {3.872343118154087*^9, 
  3.872343131241008*^9}, {3.8773368188985777`*^9, 3.87733681924405*^9}, {
  3.8926393985381527`*^9, 3.892639398890399*^9}, {3.892639468693573*^9, 
  3.892639480138549*^9}, {3.892639531009377*^9, 3.892639535274954*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"384b4b8f-5c61-46e9-8c6e-d5a28f51b6de"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "SelectFromData", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SelectFromData", "[", 
   RowBox[{"data_", ",", 
    RowBox[{"aIndices", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ".."}], "}"}]}], ",", 
    RowBox[{"bIndices", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ".."}], "}"}]}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"KeySort", "@", "data"}], "//", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "aIndices", "]"}], "]"}], "&"}], ",", "#", ",", "1"}], 
      "]"}], "&"}]}], "//", 
   RowBox[{
    RowBox[{"MapAt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "bIndices", "]"}], "]"}], "&"}], ",", "#", ",", "2"}], 
     "]"}], "&"}]}]}]}], "Input",
 CellChangeTimes->{{3.8722289851110153`*^9, 3.87222914171426*^9}, {
  3.872229202124264*^9, 3.872229210651655*^9}, {3.872229297089395*^9, 
  3.872229310311461*^9}, {3.872229390289608*^9, 3.872229583620008*^9}, {
  3.872342411597763*^9, 3.8723424285486393`*^9}, {3.872343118154087*^9, 
  3.872343131241008*^9}, {3.8773368188985777`*^9, 3.87733681924405*^9}, {
  3.8926393985381527`*^9, 3.892639398890399*^9}, {3.892639468693573*^9, 
  3.892639480138549*^9}, {3.892639531009377*^9, 3.892639535274954*^9}, {
  3.892641472392736*^9, 3.892641487172278*^9}, {3.8926415175843277`*^9, 
  3.892641524144382*^9}, {3.892641556123839*^9, 3.8926416346837397`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"d90ee519-db0e-4cf8-a3b4-34ab58d30141"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "A", " ", "helper", " ", "function", " ", "for", " ", "splitting", " ", 
    "training", " ", "data", " ", "among", " ", "the", " ", "classifiers"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "FilterTraining", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FilterTraining", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"{", 
       RowBox[{"alphaIndices_", ",", "betaIndices_"}], "}"}]}], "]"}], ":=", 
    RowBox[{"Association", "[", 
     RowBox[{
      RowBox[{"0", "->", 
       RowBox[{
        RowBox[{"data", "[", "0", "]"}], "[", 
        RowBox[{"[", "alphaIndices", "]"}], "]"}]}], ",", 
      RowBox[{"1", "->", 
       RowBox[{
        RowBox[{"data", "[", "1", "]"}], "[", 
        RowBox[{"[", "betaIndices", "]"}], "]"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.852558895897729*^9, 3.852558982139656*^9}, {
  3.892570867399453*^9, 3.8925708940494204`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"5880dcad-7b15-43cf-90c9-992674cdd2e6"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "TrainClassifiersDisjoint", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TrainClassifiersDisjoint", "[", 
   RowBox[{
   "classifiersData_", ",", "classifierTypes_List", ",", "trainIndices_List", 
    ",", "featureTypes_List", ",", "performanceGoal_String"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{"trainingSamples", ",", " ", "classifiers"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"classifiers", "=", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"classifierTypes", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Transpose", "@", 
            RowBox[{"{", 
             RowBox[{"classifiersData", ",", "trainIndices"}], "}"}]}], "//", 
           
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"FilterTraining", "@@", "#"}], "&"}], ",", "#"}], 
             "]"}], "&"}]}], ",", "\[IndentingNewLine]", "featureTypes"}], 
         "}"}]}], "//", 
       RowBox[{
        RowBox[{"Map", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Classify", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Method", "\[Rule]", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"TrainingProgressReporting", "->", "None"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PerformanceGoal", "\[Rule]", "performanceGoal"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"FeatureTypes", "->", 
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], "&"}], ",", 
          "\[IndentingNewLine]", "#"}], "]"}], "&"}]}]}], ";", 
     "\[IndentingNewLine]", "classifiers"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.871746374106735*^9, 3.8717463817674828`*^9}, {
  3.871918899897773*^9, 3.871918904921455*^9}, {3.871965324647955*^9, 
  3.8719653285315723`*^9}, {3.871965379553915*^9, 3.8719653846521606`*^9}, {
  3.8719657318145638`*^9, 3.8719657705221367`*^9}, {3.8925711241595497`*^9, 
  3.892571170307322*^9}, {3.8926406209714527`*^9, 3.8926406263055563`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"fcde2319-50bc-425a-b38f-c9473e9e5d63"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Classification", "Subsection",
 CellChangeTimes->{{3.8926420368979883`*^9, 
  3.8926420401877327`*^9}},ExpressionUUID->"761e651c-77d8-41b7-bc55-\
c7c09eeb5df7"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "LabelCounts", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LabelCounts", "[", 
   RowBox[{"classifiers_", ",", "classifiersData_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "nTestAlpha", ",", " ", "nTestBeta", ",", " ", "decisions", ",", " ", 
      "\[IndentingNewLine]", "byLabelDecisions", ",", " ", 
      "votingPatternCountsByLabel", ",", "\[IndentingNewLine]", "sols", ",", 
      "equationsToSolve", ",", "vars", ",", "\[IndentingNewLine]", "gt", ",", 
      
      RowBox[{"alphaLabel", "=", "0"}], ",", 
      RowBox[{"betaLabel", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Calculate", " ", "the", " ", "size", " ", "of", " ", "the", " ", "test",
       " ", "sets"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nTestAlpha", ",", "nTestBeta"}], "}"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"classifiersData", "//", "First"}], "//", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{"Length", ",", "#"}], "]"}], "&"}]}], "//", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", "alphaLabel", "]"}], ",", 
          RowBox[{"#", "[", "betaLabel", "]"}]}], "}"}], "&"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "We", " ", "arbitrarily", " ", "define", " ", "\"\<0\>\"", " ", "as", 
        " ", "the", " ", "alpha", " ", "label"}], ",", " ", 
       RowBox[{
       "and", " ", "\"\<1\>\"", " ", "as", " ", "the", " ", "beta", " ", 
        "label"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"decisions", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"classifiers", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{
          RowBox[{"classifiersData", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "//", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"#", "[", "alphaLabel", "]"}], ",", 
             RowBox[{"#", "[", "betaLabel", "]"}]}], "]"}], "&"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", "classifiers"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"byLabelDecisions", "=", 
      RowBox[{
       RowBox[{"decisions", "//", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TakeDrop", "[", 
             RowBox[{"#", ",", "nTestAlpha"}], "]"}], "&"}], ",", "#"}], 
          "]"}], "&"}]}], "//", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Association", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"alphaLabel", "\[Rule]", 
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"betaLabel", "\[Rule]", 
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}], "&"}], ",", 
          "#"}], "]"}], "&"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"votingPatternCountsByLabel", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"byLabelDecisions", "//", 
         RowBox[{
          RowBox[{"Merge", "[", 
           RowBox[{"#", ",", "Identity"}], "]"}], "&"}]}], "//", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{"Transpose", ",", "#"}], "]"}], "&"}]}], "//", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"Counts", ",", "#"}], "]"}], "&"}]}]}], ";", 
     "\[IndentingNewLine]", "votingPatternCountsByLabel"}]}], 
   "\[IndentingNewLine]", " ", "]"}]}]}], "Input",
 CellChangeTimes->{{3.84996583806983*^9, 3.849965838603232*^9}, {
   3.849978854466022*^9, 3.849978882348534*^9}, 3.85003738291381*^9, {
   3.850992221311371*^9, 3.850992251623*^9}, {3.871659761951393*^9, 
   3.871659791482643*^9}, {3.871706785068686*^9, 3.871706872248926*^9}, 
   3.892643058097237*^9, {3.893220851148485*^9, 3.89322087318169*^9}, {
   3.893221157199912*^9, 3.893221181339332*^9}, {3.8932222285474367`*^9, 
   3.8932222319188423`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"c95d702d-746a-4d0c-a5fb-9a9722999de1"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 842},
WindowMargins->{{464, Automatic}, {Automatic, 29}},
FrontEndVersion->"13.2 for Mac OS X ARM (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4fc2a053-51ed-45f2-9618-5208d91db66d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 153, 3, 84, "Section",ExpressionUUID->"a7b4ed64-894b-4ded-8663-31b37972111e"],
Cell[CellGroupData[{
Cell[758, 29, 154, 3, 67, "Subsection",ExpressionUUID->"0fce8476-a711-4e80-a4f3-54dea8b20405"],
Cell[915, 34, 1615, 40, 324, "Input",ExpressionUUID->"f0467122-ca6f-4e75-88d0-b126ee0d7b96"],
Cell[2533, 76, 297, 6, 73, "Text",ExpressionUUID->"dd19b2d7-0b02-49c2-b0ee-fa49b3799569"],
Cell[CellGroupData[{
Cell[2855, 86, 1302, 33, 142, "Input",ExpressionUUID->"baa656de-5c12-4d7f-b1b5-3eeb88a462d8"],
Cell[4160, 121, 1233, 32, 121, "Output",ExpressionUUID->"b8f65592-a993-4002-9d8d-4397c804ea42"]
}, Open  ]],
Cell[5408, 156, 1832, 48, 194, "Input",ExpressionUUID->"df5a980b-036d-4797-b390-8cfa1a0721b9"],
Cell[7243, 206, 1813, 46, 194, "Input",ExpressionUUID->"c3e11402-339f-4cc6-92d4-55c952bac78b"]
}, Open  ]],
Cell[9071, 255, 159, 3, 67, "Subsection",ExpressionUUID->"bbeac00d-d4e6-4715-912b-654f423e550c"],
Cell[CellGroupData[{
Cell[9255, 262, 189, 3, 46, "Subsection",ExpressionUUID->"5e44984e-20a3-4891-9c1c-d98bcc7f3308"],
Cell[9447, 267, 2790, 73, 376, "Input",ExpressionUUID->"cb26d95a-553b-423c-91bc-b23a034cda23"],
Cell[12240, 342, 1908, 57, 324, "Input",ExpressionUUID->"88dcf551-eb5d-41a0-ae20-86fd5ce02d5a"],
Cell[14151, 401, 862, 24, 116, "Input",ExpressionUUID->"2d96dd7c-ceb3-4750-b28f-c965708c8dd2"],
Cell[15016, 427, 3459, 79, 454, "Input",ExpressionUUID->"5ffe11ec-2c43-4a1c-92fd-7922dbfc94fd"],
Cell[18478, 508, 4919, 126, 732, "Input",ExpressionUUID->"53ab4a81-9b4a-4340-8ba1-543cee642e3a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23434, 639, 155, 3, 67, "Subsection",ExpressionUUID->"87d37b3d-8d48-4698-9db1-c2fe89182e67"],
Cell[23592, 644, 7480, 227, 295, "Input",ExpressionUUID->"eb2aee6a-083b-46d5-ae4f-257222765dda"],
Cell[31075, 873, 2895, 65, 324, "Input",ExpressionUUID->"40e77f3c-1bda-4311-a481-2d585770f817"],
Cell[33973, 940, 863, 20, 168, "Input",ExpressionUUID->"c0276646-a518-4bd0-aadb-7d7fbbc12697"],
Cell[34839, 962, 890, 22, 92, "Input",ExpressionUUID->"754393f6-e7e7-46f6-9efd-77ef77dbcf54"],
Cell[35732, 986, 553, 15, 116, "Input",ExpressionUUID->"e362c9ac-04ca-49d6-815f-15f57c490756"],
Cell[36288, 1003, 897, 20, 194, "Input",ExpressionUUID->"64ee429e-4fbd-4bfa-a4b4-89985c08a17e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37222, 1028, 236, 4, 67, "Subsection",ExpressionUUID->"d3d8b6d4-61ba-452a-81fe-fd83cd6d8a50"],
Cell[37461, 1034, 1373, 33, 194, "Input",ExpressionUUID->"8c0f2858-f80f-4371-a763-b22a07943a30"],
Cell[38837, 1069, 3592, 79, 558, "Input",ExpressionUUID->"4b60f1e3-3970-44b8-bbe7-5984feef9719"],
Cell[42432, 1150, 1072, 24, 142, "Input",ExpressionUUID->"fe8427ad-700f-423c-932b-fa92d7c152cc"],
Cell[43507, 1176, 1456, 38, 194, "Input",ExpressionUUID->"cd5d2c3a-bd4f-4d88-b476-c90b9f23f459"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45000, 1219, 200, 3, 67, "Subsection",ExpressionUUID->"d4a11728-5298-4492-99fe-3c6c096b16c2"],
Cell[45203, 1224, 6168, 152, 700, "Input",ExpressionUUID->"6209b446-8896-4cd9-9e5d-42cb49e9793e"],
Cell[CellGroupData[{
Cell[51396, 1380, 166, 3, 56, "Subsubsection",ExpressionUUID->"7ebd56d7-8ad1-4998-8e72-66119ab20ca5"],
Cell[51565, 1385, 1423, 36, 168, "Input",ExpressionUUID->"c94ec724-e769-48d9-a501-44f92d3127ad"],
Cell[52991, 1423, 1844, 48, 168, "Input",ExpressionUUID->"40e43f9e-0d15-4bed-8298-424d14bba147"],
Cell[54838, 1473, 421, 8, 64, "Input",ExpressionUUID->"41ff53cb-f49b-4646-b381-6f307b642c2b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55308, 1487, 168, 3, 67, "Subsection",ExpressionUUID->"9600e475-bf31-44e0-93cb-9a84c189e35c"],
Cell[55479, 1492, 2432, 62, 402, "Input",ExpressionUUID->"f22d3a68-2983-4537-a563-2855d696d359"],
Cell[57914, 1556, 2183, 54, 272, "Input",ExpressionUUID->"53a30dd0-9474-4a08-a4b8-2a9855e0d68f"],
Cell[60100, 1612, 1209, 28, 194, "Input",ExpressionUUID->"060ba8ed-fda7-4b26-8327-4d4d94d03634"],
Cell[61312, 1642, 745, 16, 116, "Input",ExpressionUUID->"25067183-bb4f-439a-b130-a2be6a336e14"],
Cell[62060, 1660, 2274, 55, 272, "Input",ExpressionUUID->"384b4b8f-5c61-46e9-8c6e-d5a28f51b6de"],
Cell[64337, 1717, 1598, 38, 142, "Input",ExpressionUUID->"d90ee519-db0e-4cf8-a3b4-34ab58d30141"],
Cell[65938, 1757, 1067, 26, 142, "Input",ExpressionUUID->"5880dcad-7b15-43cf-90c9-992674cdd2e6"],
Cell[67008, 1785, 2534, 56, 454, "Input",ExpressionUUID->"fcde2319-50bc-425a-b38f-c9473e9e5d63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69579, 1846, 166, 3, 67, "Subsection",ExpressionUUID->"761e651c-77d8-41b7-bc55-c7c09eeb5df7"],
Cell[69748, 1851, 4378, 109, 636, "Input",ExpressionUUID->"c95d702d-746a-4d0c-a5fb-9a9722999de1"]
}, Open  ]]
}, Open  ]]
}
]
*)

