(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22978,        522]
NotebookOptionsPosition[     21048,        478]
NotebookOutlinePosition[     21592,        499]
CellTagsIndexPosition[     21549,        496]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Distance to containingvariety: The ",
 Cell[BoxData[
 Cell["UCI Adult", "InlineCode",ExpressionUUID->
   "8c3c66ad-4ba8-4e02-9e14-6c964f65b1e1"]], "InlineCode",ExpressionUUID->
  "0a0cd5ad-1ccd-4580-b3d1-648e8e915c08"],
 " dataset II"
}], "Title",
 CellChangeTimes->{{3.870416494807392*^9, 3.8704165149389963`*^9}, {
   3.8728244644751368`*^9, 3.872824492105381*^9}, {3.8773347884125433`*^9, 
   3.877334789157092*^9}, 3.877334864620109*^9, {3.87733489498519*^9, 
   3.8773349089413977`*^9}, {3.877334992371562*^9, 3.8773351453602657`*^9}, {
   3.878564688139502*^9, 3.878564691112658*^9}, {3.89283727077804*^9, 
   3.8928372720213346`*^9}, {3.89321640796461*^9, 3.8932164090035353`*^9}, {
   3.893893768261676*^9, 
   3.893893775825775*^9}},ExpressionUUID->"bcd3c995-0cc1-4a17-bbbb-\
3a732f1bacde"],

Cell[TextData[{
 "An experimental demonstration, using the UCI ",
 StyleBox["adult",
  FontFamily->"Roboto",
  FontWeight->"Bold"],
 " dataset, that the failures of the independent stream evaluator for binary \
classifiers can be used to find nearly independent trios on unlabeled data.\n\
\nWe read some common code for the three datasets"
}], "Text",
 CellChangeTimes->{{3.870416560007392*^9, 3.870416687666049*^9}, {
   3.870416753673461*^9, 3.8704167843086433`*^9}, {3.87041688019711*^9, 
   3.8704179787978563`*^9}, {3.872824630802247*^9, 3.8728247465135*^9}, {
   3.872824879536249*^9, 3.8728249904066057`*^9}, {3.872825028580565*^9, 
   3.872825446071165*^9}, {3.8728254796306057`*^9, 3.87282561291549*^9}, {
   3.8728256473624372`*^9, 3.872825818229589*^9}, 3.877335170454104*^9, {
   3.877335277799707*^9, 3.8773354135556*^9}, {3.878099685485421*^9, 
   3.8780997076315107`*^9}, {3.87809973956047*^9, 3.8780997425274563`*^9}, {
   3.878099796200707*^9, 3.878099931047056*^9}, {3.878099971417561*^9, 
   3.878100047695458*^9}, {3.878100122890733*^9, 3.878100303698058*^9}, {
   3.8781003527565737`*^9, 3.8781004720109653`*^9}, {3.8781005092652884`*^9, 
   3.87810063813365*^9}, {3.8781006707957087`*^9, 3.878100741599815*^9}, {
   3.878100774302137*^9, 3.87810081023703*^9}, {3.878564714269315*^9, 
   3.8785647456558104`*^9}, {3.8925688550785017`*^9, 3.892568909688491*^9}, {
   3.8925689522365837`*^9, 3.892568957413231*^9}, {3.8926513345657377`*^9, 
   3.892651353914339*^9}},ExpressionUUID->"4d69d43d-fca1-4c9f-b4de-\
bc7c9c8ddb12"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nbDir", " ", "=", " ", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "nbDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NotebookEvaluate", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"nbDir", ",", "\"\<CommonCode.nb\>\""}], "}"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.892651664814858*^9, 3.892651706773838*^9}, {
  3.892651804438521*^9, 3.892651823515175*^9}, {3.892651929726159*^9, 
  3.892651930016461*^9}, {3.8926519786606703`*^9, 3.892652021585513*^9}, {
  3.892652053162012*^9, 3.892652071400268*^9}, {3.892652113572515*^9, 
  3.8926522011251793`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"9ffd75ab-68ca-421a-8eba-4c022a1bd3ec"],

Cell[CellGroupData[{

Cell["Getting the data and taking a look at the available features", "Section",
 CellChangeTimes->{{3.870418735367992*^9, 3.8704187695502863`*^9}, {
  3.870596606676496*^9, 3.8705966396036253`*^9}, {3.877335429643175*^9, 
  3.877335448437654*^9}},ExpressionUUID->"e4431d5b-799b-40cd-89da-\
495df9619242"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tsvHeader", ",", " ", "benchmarkData"}], "}"}], " ", "=", " ", 
   RowBox[{"ImportPennMLBenchmarksDataset", "[", "\"\<adult\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8705235525461493`*^9, 3.8705235571860437`*^9}, {
  3.870596259432252*^9, 3.870596283037717*^9}, {3.877335452972402*^9, 
  3.877335454315721*^9}, {3.878564774795635*^9, 3.878564776872191*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"07259698-ce42-481a-baae-128f16fcde68"],

Cell[CellGroupData[{

Cell[BoxData["tsvHeader"], "Input",
 CellChangeTimes->{{3.870523583077188*^9, 3.8705235866731453`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"b1262ebf-6e0a-4983-8bcb-4a655a305a0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"age\"\>", ",", "\<\"workclass\"\>", ",", "\<\"fnlwgt\"\>", 
   ",", "\<\"education\"\>", ",", "\<\"education-num\"\>", 
   ",", "\<\"marital-status\"\>", ",", "\<\"occupation\"\>", 
   ",", "\<\"relationship\"\>", ",", "\<\"race\"\>", ",", "\<\"sex\"\>", 
   ",", "\<\"capital-gain\"\>", ",", "\<\"capital-loss\"\>", 
   ",", "\<\"hours-per-week\"\>", ",", "\<\"native-country\"\>", 
   ",", "\<\"target\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.870523588133562*^9, 3.870596289409478*^9, 
  3.871638540395935*^9, 3.871706906357135*^9, 3.8717090853936033`*^9, 
  3.871717587823229*^9, 3.871724110745204*^9, 3.871969349503574*^9, 
  3.87197171029183*^9, 3.8720667345791607`*^9, 3.872073865428359*^9, 
  3.872306715558063*^9, 3.872314473142736*^9, 3.872826635366192*^9, 
  3.877335466343186*^9, 3.877591423809586*^9, 3.8781008907356997`*^9, 
  3.8785647846498623`*^9, 3.892618866971345*^9, 3.892652289872514*^9, 
  3.8926525157893887`*^9, 3.892658191498096*^9, 3.892702201789298*^9, 
  3.8927067899981623`*^9, 3.8928073707791862`*^9, 3.892830123500276*^9, 
  3.892834462067335*^9, 3.892841345747596*^9, 3.892841406487049*^9, 
  3.89288565088008*^9, 3.89293122761207*^9, 3.893217104677621*^9, 
  3.893252294134822*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"c8124c18-066e-4b41-a64c-8a0438cc4061"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["uciAdultFeatures"], "Input",
 CellChangeTimes->{{3.877337437293154*^9, 3.877337494888242*^9}, {
  3.87856495603835*^9, 3.878564957383402*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"3b8fc3ea-e203-41e6-ad3a-743159983f76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "\<\"Nominal\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "\<\"Numerical\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "\<\"Nominal\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.87733746349279*^9, 3.877337495986581*^9, 
  3.8775914317621183`*^9, 3.878101069518462*^9, 3.878564958376603*^9, 
  3.879148827749604*^9, 3.892618873302746*^9, 3.892619039399386*^9, 
  3.892652289910068*^9, 3.892652515826212*^9, 3.892658191539904*^9, 
  3.892702201821457*^9, 3.892706790019773*^9, 3.8928073707954206`*^9, 
  3.89283012352526*^9, 3.892834462102223*^9, 3.8928413457693233`*^9, 
  3.892841406506752*^9, 3.89288565089988*^9, 3.892931227630509*^9, 
  3.893217104697575*^9, 3.893252294157629*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"66b809f7-ba3a-4fa0-aa8d-d460174d9540"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "benchmarkData"}]], "Input",
 CellChangeTimes->{{3.877336562112534*^9, 3.877336573343268*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"bd421011-0606-4dfc-9ca4-d6d0aab68c16"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "37155"}], ",", 
   RowBox[{"0", "\[Rule]", "11687"}]}], "\[RightAssociation]"}]], "Output",
 CellChangeTimes->{{3.8773365661609*^9, 3.877336574467449*^9}, 
   3.877591436393881*^9, 3.878101086643124*^9, 3.878565012931489*^9, 
   3.87914888292692*^9, 3.892619050708255*^9, 3.89265228999396*^9, 
   3.8926525159000063`*^9, 3.8926581916240587`*^9, 3.892702201888033*^9, 
   3.892706790078054*^9, 3.8928073708463287`*^9, 3.892830123584457*^9, 
   3.8928344621592712`*^9, 3.892841345816963*^9, 3.892841406552682*^9, 
   3.8928856509549007`*^9, 3.8929312276826963`*^9, 3.8932171047481213`*^9, 
   3.893252294191581*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"27a4e626-be14-4629-96d7-c2714dde71ee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experiments", "Section",
 CellChangeTimes->{{3.8932684353715763`*^9, 3.893268437815144*^9}, {
  3.893893806809992*^9, 
  3.8938938081625557`*^9}},ExpressionUUID->"ba6d33d7-ce20-4fd5-952b-\
92600ad7e68a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"manyFeaturePartitions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"RandomSample", "[", "uciAdultFeatures", "]"}], "//", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Partition", "[", 
              RowBox[{"#", ",", 
               RowBox[{"UpTo", "@", "3"}]}], "]"}], "&"}]}], "//", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{"#", ",", "3"}], "]"}], "&"}]}], ",", 
          RowBox[{"{", "1000", "}"}]}], "]"}], "//", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{"Sort", ",", "#", ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], "&"}]}], "//", 
       RowBox[{
        RowBox[{"Sort", "/@", "#"}], "&"}]}], "//", "DeleteDuplicates"}], "//", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{"#", ",", "20"}], "]"}], "&"}]}], "//", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"#", ",", "3"}], "]"}], "&"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.89326844851525*^9, 3.89326855059719*^9}, {
  3.893268859806822*^9, 3.8932688724753647`*^9}},
 CellLabel->
  "In[388]:=",ExpressionUUID->"8127e02d-f25a-43db-9450-f47baf8b5793"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "4"}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nTrain", "=", "200"}], ";", "\[IndentingNewLine]", 
    RowBox[{"globalTrainSize", "=", "600"}], ";", "\[IndentingNewLine]", 
    RowBox[{"nClassifiers", "=", "3"}], ";", "\[IndentingNewLine]", 
    RowBox[{"classifierTypes", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<LogisticRegression\>\"", ",", 
         RowBox[{"\"\<L1Regularization\>\"", "->", "0.1"}], ",", 
         RowBox[{"\"\<L2Regularization\>\"", "->", "0.5"}], ",", 
         RowBox[{"\"\<OptimizationMethod\>\"", "->", "\"\<Newton\>\""}]}], 
        "}"}], ",", 
       RowBox[{"{", "nClassifiers", "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"We", " ", "separate", " ", "a", " ", "held"}], "-", 
      RowBox[{
      "out", " ", "test", " ", "set", " ", "that", " ", "is", " ", "never", 
       " ", "seen", " ", "in", " ", "any", " ", "of", " ", "the", " ", 
       "training", "\[IndentingNewLine]", "runs", " ", "below"}]}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"aTrainIndices", " ", "=", " ", 
     RowBox[{"RandomSample", "[", 
      RowBox[{
       RowBox[{"Range", "@", 
        RowBox[{"Length", "@", 
         RowBox[{"benchmarkData", "[", "0", "]"}]}]}], ",", 
       "globalTrainSize"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"bTrainIndices", " ", "=", " ", 
     RowBox[{"RandomSample", "[", 
      RowBox[{
       RowBox[{"Range", "@", 
        RowBox[{"Length", "@", 
         RowBox[{"benchmarkData", "[", "1", "]"}]}]}], ",", 
       "globalTrainSize"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"globalTrainTestSplit", " ", "=", 
     RowBox[{"MakeTrainTestSplit", "[", 
      RowBox[{
      "benchmarkData", ",", "aTrainIndices", ",", " ", "bTrainIndices"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"globalTrainData", " ", "=", " ", 
     RowBox[{"SelectTrainDataFromSplit", "[", "globalTrainTestSplit", "]"}]}],
     ";", "\[IndentingNewLine]", 
    RowBox[{"globalHOData", " ", "=", " ", 
     RowBox[{"SelectTestDataFromSplit", "[", "globalTrainTestSplit", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"nTest", "=", "2000"}], ";", "\[IndentingNewLine]", 
    RowBox[{"runs", " ", "=", " ", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"classifiersFeatures", ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Select", " ", "random"}], ",", " ", 
            RowBox[{
            "disjoint", " ", "partitions", " ", "of", " ", "the", " ", 
             "training", " ", "data"}], ",", "\[IndentingNewLine]", 
            RowBox[{"grouped", " ", "by", " ", "classifier"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"trainIndices", "=", 
             RowBox[{"Transpose", "@", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a",
                  " ", "subset", " ", "of", " ", "the", " ", "alpha", " ", 
                 "training", " ", "data"}], " ", "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"ClassifiersSampleIndices", "[", 
                 RowBox[{
                  RowBox[{"globalTrainData", "[", "0", "]"}], ",", "nTrain"}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"(*", " ", 
                 RowBox[{
                 "The", " ", "disjoint", " ", "partition", " ", "of", " ", 
                  "a", " ", "subset", " ", "of", " ", "the", " ", "beta", " ",
                   "training", " ", "data"}], " ", "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"ClassifiersSampleIndices", "[", 
                 RowBox[{
                  RowBox[{"globalTrainData", "[", "1", "]"}], ",", " ", 
                  "nTrain"}], "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
            
            RowBox[{"(*", " ", 
             RowBox[{
             "Prepare", " ", "the", " ", "training", " ", "data", " ", "for", 
              " ", "the", " ", "current", " ", "feature", " ", "partitions"}],
              " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"trainClassifiersData", "=", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", 
                    RowBox[{"First", "@", 
                    RowBox[{"Transpose", "@", "features"}]}], "]"}], "]"}], 
                  "&"}], ",", "globalTrainData", ",", 
                 RowBox[{"{", "2", "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"features", ",", "classifiersFeatures"}], "}"}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"classifiers", " ", "=", " ", 
             RowBox[{"TrainClassifiersDisjoint", "[", 
              RowBox[{
              "trainClassifiersData", ",", "classifierTypes", ",", 
               "trainIndices", ",", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Last", "@", 
                    RowBox[{"Transpose", "@", "#"}]}], ")"}], "&"}], ",", 
                 "classifiersFeatures"}], "]"}], ",", 
               "\"\<TrainingSpeed\>\""}], "]"}]}], ";", "\[IndentingNewLine]",
             "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Now", " ", "evaluate"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"evalIndices", "=", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
               "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a", 
                " ", "subset", " ", "of", " ", "the", " ", "alpha", " ", 
                "training", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"SampleIndices", "[", 
                RowBox[{
                 RowBox[{"globalHOData", "[", "0", "]"}], ",", "nTest"}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                "The", " ", "disjoint", " ", "partition", " ", "of", " ", "a",
                  " ", "subset", " ", "of", " ", "the", " ", "beta", " ", 
                 "training", " ", "data"}], " ", "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{"SampleIndices", "[", 
                RowBox[{
                 RowBox[{"globalHOData", "[", "1", "]"}], ",", " ", "nTest"}],
                 "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"testClassifiersData", "=", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", 
                    RowBox[{"First", "@", 
                    RowBox[{"Transpose", "@", "features"}]}], "]"}], "]"}], 
                  "&"}], ",", 
                 RowBox[{"SelectFromData", "[", 
                  RowBox[{"globalHOData", ",", 
                   RowBox[{"First", "@", "evalIndices"}], ",", 
                   RowBox[{"Last", "@", "evalIndices"}]}], "]"}], ",", 
                 RowBox[{"{", "2", "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"features", ",", "classifiersFeatures"}], "}"}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"vcbl", "=", 
             RowBox[{"LabelCounts", "[", 
              RowBox[{"classifiers", ",", "testClassifiersData"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"Which", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Not", "@", 
               RowBox[{"HasAllDecisionFrequenciesQ", "@", " ", "vcbl"}]}], 
              " ", ",", "\[IndentingNewLine]", "Nothing", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Not", "@", 
               RowBox[{
               "IndependentEvaluationIdealIsNonEmptyQ", "@", "vcbl"}]}], ",", 
              "\[IndentingNewLine]", "Nothing", ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"sols", "=", 
                RowBox[{
                "AlgebraicallyEvaluateClassifiers", "[", "vcbl", "]"}]}], ";",
                "\[IndentingNewLine]", 
               RowBox[{"Not", "@", 
                RowBox[{"HasOnlyRealNumbersQ", "@", "sols"}]}]}], ",", 
              "\[IndentingNewLine]", "Nothing", ",", "\[IndentingNewLine]", 
              RowBox[{"Not", "@", 
               RowBox[{"InsideUnitCubeQ", "@", "sols"}]}], ",", 
              "\[IndentingNewLine]", "Nothing", ",", "\[IndentingNewLine]", 
              "True", ",", "\[IndentingNewLine]", "vcbl"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", "10", "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"classifiersFeatures", ",", 
         RowBox[{"manyFeaturePartitions", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"runs", " ", ">>", " ", 
     RowBox[{"\"\<./adult-ni-\>\"", "~~", 
      RowBox[{"ToString", "[", "i", "]"}], "~~", "\"\<.m\>\""}]}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.893268562088086*^9, 3.8932685898495502`*^9}, {
  3.8932686501038322`*^9, 3.893268730521718*^9}, {3.8932687692714243`*^9, 
  3.893268828945869*^9}, {3.893268892697523*^9, 3.893268895795384*^9}, {
  3.8938938275804977`*^9, 
  3.893893832235113*^9}},ExpressionUUID->"916a4659-8292-4921-9c4c-\
4dc34d541a7d"]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Local2",
WindowSize->{1581, 888},
WindowMargins->{{Automatic, 27}, {Automatic, 36}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>1.5 Inherited,
FrontEndVersion->"13.2 for Mac OS X ARM (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d99fd17d-814b-4243-8ceb-f0cf820fb6f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 817, 16, 301, "Title",ExpressionUUID->"bcd3c995-0cc1-4a17-bbbb-3a732f1bacde"],
Cell[1400, 40, 1544, 25, 189, "Text",ExpressionUUID->"4d69d43d-fca1-4c9f-b4de-bc7c9c8ddb12"],
Cell[2947, 67, 787, 16, 134, "Input",ExpressionUUID->"9ffd75ab-68ca-421a-8eba-4c022a1bd3ec"],
Cell[CellGroupData[{
Cell[3759, 87, 304, 4, 126, "Section",ExpressionUUID->"e4431d5b-799b-40cd-89da-495df9619242"],
Cell[4066, 93, 516, 10, 55, "Input",ExpressionUUID->"07259698-ce42-481a-baae-128f16fcde68"],
Cell[CellGroupData[{
Cell[4607, 107, 182, 2, 55, "Input",ExpressionUUID->"b1262ebf-6e0a-4983-8bcb-4a655a305a0a"],
Cell[4792, 111, 1342, 21, 103, "Output",ExpressionUUID->"c8124c18-066e-4b41-a64c-8a0438cc4061"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6171, 137, 235, 3, 55, "Input",ExpressionUUID->"3b8fc3ea-e203-41e6-ad3a-743159983f76"],
Cell[6409, 142, 1697, 39, 142, "Output",ExpressionUUID->"66b809f7-ba3a-4fa0-aa8d-d460174d9540"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8143, 186, 212, 3, 55, "Input",ExpressionUUID->"bd421011-0606-4dfc-9ca4-d6d0aab68c16"],
Cell[8358, 191, 777, 13, 63, "Output",ExpressionUUID->"27a4e626-be14-4629-96d7-c2714dde71ee"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9184, 210, 209, 4, 126, "Section",ExpressionUUID->"ba6d33d7-ce20-4fd5-952b-92600ad7e68a"],
Cell[9396, 216, 1403, 39, 212, "Input",ExpressionUUID->"8127e02d-f25a-43db-9450-f47baf8b5793"],
Cell[10802, 257, 10218, 217, 2279, "Input",ExpressionUUID->"916a4659-8292-4921-9c4c-4dc34d541a7d"]
}, Open  ]]
}, Open  ]]
}
]
*)

