(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     83881,       2264]
NotebookOptionsPosition[     79954,       2188]
NotebookOutlinePosition[     80350,       2204]
CellTagsIndexPosition[     80307,       2201]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Groebner basis for three correlated classifiers", "Title",
 CellChangeTimes->{{3.893788640099551*^9, 
  3.89378865073283*^9}},ExpressionUUID->"23fbb238-f20f-4269-bc9e-\
d420ab787d81"],

Cell[CellGroupData[{

Cell["Code", "Section",
 CellChangeTimes->{{3.893789771005323*^9, 
  3.893789771401392*^9}},ExpressionUUID->"a79e920b-c85e-4532-8b4d-\
16acf791b01d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"piRules", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"1", ",", "\[Alpha]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"1", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]]}]}], ",", 
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"1", ",", "\[Beta]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"1", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}]}], ",", 
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"2", ",", "\[Alpha]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"2", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]]}]}], ",", 
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"2", ",", "\[Beta]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"2", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}]}], ",", 
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"3", ",", "\[Alpha]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"3", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}]}], ",", 
     RowBox[{
      SubscriptBox["P", 
       RowBox[{"3", ",", "\[Beta]"}]], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Pi]", 
        RowBox[{"3", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.893791046306725*^9, 3.893791050238958*^9}, 
   3.893791195979735*^9},
 CellLabel->
  "In[284]:=",ExpressionUUID->"9b7d7b58-de68-45f8-97ae-e91eb0a67a63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gammaRules", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"1", ",", "2", ",", "\[Alpha]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"1", ",", "2", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], 
         ")"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"1", ",", "2", ",", "\[Beta]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"1", ",", "2", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], 
         ")"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"1", ",", "3", ",", "\[Alpha]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"1", ",", "3", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
         ")"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"1", ",", "3", ",", "\[Beta]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"1", ",", "3", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], 
         ")"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"2", ",", "3", ",", "\[Alpha]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"2", ",", "3", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
         ")"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"2", ",", "3", ",", "\[Beta]"}]], "->", 
      RowBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{"2", ",", "3", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], 
         ")"}]}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.893790241837302*^9, 3.893790298970768*^9}, {
  3.893790330669401*^9, 3.893790396264811*^9}, {3.8937909294736767`*^9, 
  3.8937909573714247`*^9}, {3.8937910729810343`*^9, 3.893791130686372*^9}, {
  3.893791163369466*^9, 3.8937912008414707`*^9}, {3.8937913633770514`*^9, 
  3.893791502041103*^9}, {3.893791557168029*^9, 3.8937915676123447`*^9}, {
  3.8937922566312637`*^9, 3.8937922597277718`*^9}},
 CellLabel->
  "In[296]:=",ExpressionUUID->"48031b9d-5bc7-4b9f-925e-376a2146d6d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The raw Groebner basis", "Section",
 CellChangeTimes->{{3.893788676810916*^9, 
  3.893788683770012*^9}},ExpressionUUID->"e642675d-1eaa-4422-99a7-\
19fe2369390b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"generatingSet3CorrelatedClassifiers", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Alpha]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Beta]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "-", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["f", 
        RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"k", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"j", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Alpha]"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["P", 
             RowBox[{"i", ",", "\[Alpha]"}]]}], ")"}], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Alpha]"}]]}], "-", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["P", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"k", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"j", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "+", 
         RowBox[{
          SubscriptBox["P", 
           RowBox[{"i", ",", "\[Beta]"}]], " ", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "+", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], ")"}]}]}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.893788743255045*^9, 3.893788804751493*^9}},
 CellLabel->
  "In[255]:=",ExpressionUUID->"ff1cdb4a-bef4-463d-99b9-15de8893eace"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vars", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Variables", "/@", "generatingSet3CorrelatedClassifiers"}], "//",
        "Flatten"}], "//", 
      RowBox[{
       RowBox[{"Cases", "[", 
        RowBox[{"#", ",", 
         RowBox[{"Except", "[", 
          SubscriptBox["f", "__"], "]"}]}], "]"}], "&"}]}], "//", 
     "DeleteDuplicates"}], "//", "Sort"}], "//", 
   RowBox[{
    RowBox[{"SortBy", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Length", "@", "#"}], ",", 
         RowBox[{"Last", "@", "#"}], ",", 
         RowBox[{"First", "@", "#"}]}], "}"}], "&"}]}], "]"}], 
    "&"}]}]}]], "Input",
 CellChangeTimes->{{3.893788832809243*^9, 3.893788838616473*^9}},
 CellLabel->
  "In[256]:=",ExpressionUUID->"c0141e08-6f5d-416f-8b26-17027638d8e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["P", "\[Alpha]"], ",", 
   SubscriptBox["P", "\[Beta]"], ",", 
   SubscriptBox["P", 
    RowBox[{"i", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["P", 
    RowBox[{"j", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["P", 
    RowBox[{"k", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["P", 
    RowBox[{"i", ",", "\[Beta]"}]], ",", 
   SubscriptBox["P", 
    RowBox[{"j", ",", "\[Beta]"}]], ",", 
   SubscriptBox["P", 
    RowBox[{"k", ",", "\[Beta]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "j", ",", "\[Beta]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "k", ",", "\[Beta]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"j", ",", "k", ",", "\[Beta]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.893788839982362*^9},
 CellLabel->
  "Out[256]=",ExpressionUUID->"52426856-62d5-4ae0-88bb-885cca24d821"]
}, Open  ]],

Cell["\<\
Variable and monomial orderings are crucial to Groebner basis calculations. \
Using standard monomial orderings such as Lexicographic or Reverse \
Lexicographic do not return from this calculation or take a large time to do \
so. The following monomial ordering is exploiting our knowledge
of the symmetries in the variables and the polynomials.\
\>", "Text",
 CellChangeTimes->{{3.893788896782689*^9, 
  3.8937890239315968`*^9}},ExpressionUUID->"1de82b06-e3fd-4854-94b2-\
8490ed1942a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"elimType", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.893788874972802*^9, 3.8937888773206577`*^9}, {
  3.893789026636977*^9, 3.893789031003314*^9}},
 CellLabel->
  "In[257]:=",ExpressionUUID->"9da651d8-13a7-414f-9b92-f18c41764e67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"gb", "=", 
    RowBox[{"GroebnerBasis", "[", 
     RowBox[{"generatingSet3CorrelatedClassifiers", ",", 
      RowBox[{"Reverse", "@", "vars"}], ",", 
      RowBox[{"MonomialOrder", "\[Rule]", "elimType"}], ",", 
      RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], 
     "]"}]}], ";"}], "]"}]], "Input",
 CellChangeTimes->{{3.893789075678369*^9, 3.893789086652835*^9}},
 CellLabel->
  "In[258]:=",ExpressionUUID->"4b5be177-5eb9-4ff6-9d5e-a4c935419430"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.762325`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.893789095215192*^9},
 CellLabel->
  "Out[258]=",ExpressionUUID->"c0b7fb26-eb30-4467-b1d3-42e3ba87eb14"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "gb"}]], "Input",
 CellChangeTimes->{{3.893789102959655*^9, 3.893789105787961*^9}},
 CellLabel->
  "In[259]:=",ExpressionUUID->"f95eb373-67d4-4b4b-87ee-65fd83b50f96"],

Cell[BoxData["29"], "Output",
 CellChangeTimes->{3.8937891089578533`*^9},
 CellLabel->
  "Out[259]=",ExpressionUUID->"1b973c94-6649-4c4e-8f69-c4106b181967"]
}, Open  ]],

Cell["The variables in each of the basis polynomials", "Text",
 CellChangeTimes->{{3.893789243291169*^9, 
  3.893789264751745*^9}},ExpressionUUID->"ea07b63c-b7e0-4216-95c5-\
af7e866d48f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"Variables", ",", "gb"}], "]"}], "//", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cases", "[", 
         RowBox[{"#", ",", 
          RowBox[{"Except", "[", 
           SubscriptBox["f", "__"], "]"}]}], "]"}], "&"}], ",", "#"}], "]"}], 
     "&"}]}], "//", 
   RowBox[{
    RowBox[{"Sort", "/@", "#"}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8937892676836987`*^9, 3.893789269069871*^9}, {
  3.8937893336578827`*^9, 3.893789381568047*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"98b31c71-561a-4fcd-b911-25ca997892a1"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", "\[Beta]"]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", "\[Alpha]"], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"i", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"j", ",", "\[Beta]"}]], ",", 
       SubscriptBox["P", 
        RowBox[{"k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"j", ",", "k", ",", "\[Beta]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}]], ",", 
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"i", ",", "j", ",", "k", ",", "\[Beta]"}]]}], "}"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.893789346666401*^9, 3.893789382852907*^9}},
 CellLabel->
  "Out[262]=",ExpressionUUID->"9f105b17-fc2f-485f-af70-3c9536916494"]
}, Open  ]],

Cell["\<\
The first polynomial in the basis asserts that the frequencies must sum to \
one for the ideal to be well-defined.\
\>", "Text",
 CellChangeTimes->{{3.893789468664524*^9, 
  3.893789510919044*^9}},ExpressionUUID->"14c37b8e-4510-4f13-bc06-\
0bb6a6ca61bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "//", "First"}]], "Input",
 CellChangeTimes->{{3.893789451909915*^9, 3.89378945532899*^9}},
 CellLabel->
  "In[263]:=",ExpressionUUID->"2724c8a2-ee87-4956-80ef-fa51ca5545bb"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["P", "\[Alpha]"], "+", 
  SubscriptBox["P", "\[Beta]"], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]], "-", 
  SubscriptBox["f", 
   RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]]}]], "Output",
 CellChangeTimes->{3.893789456148137*^9},
 CellLabel->
  "Out[263]=",ExpressionUUID->"f4e4bc8b-f51d-40af-bd63-7c74e4784518"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
New variables to make highlight the blind spots in the evaluation ideal\
\>", "Section",
 CellChangeTimes->{{3.8937895822229643`*^9, 3.893789617160726*^9}, {
  3.8937896475101233`*^9, 
  3.893789650922591*^9}},ExpressionUUID->"599ab672-280b-42aa-ac31-\
29c2081b46f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"gb", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "->", "1"}], ",", 
          RowBox[{"j", "->", "2"}], ",", 
          RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", "piRules"}], 
     ")"}], "//", "Expand"}], "//", "Simplify"}], "//", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        SubscriptBox["f", 
         RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
       RowBox[{"1", "-", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], ")"}]}]}],
       "}"}]}], ")"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.89379183244912*^9, 3.8937919244021387`*^9}, {
  3.89379200010455*^9, 3.893792011261077*^9}, {3.893792139851775*^9, 
  3.8937921556882*^9}, {3.8937924551351233`*^9, 3.893792456542707*^9}, {
  3.89379254767117*^9, 3.893792549093692*^9}},
 CellLabel->
  "In[303]:=",ExpressionUUID->"34b61a66-d642-4a88-b0a0-dbf2820bcd62"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Pi]", 
   RowBox[{"1", ",", "\[Beta]"}]], "-", 
  RowBox[{
   SubscriptBox["P", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Pi]", 
      RowBox[{"1", ",", "\[Alpha]"}]], "+", 
     SubscriptBox["\[Pi]", 
      RowBox[{"1", ",", "\[Beta]"}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.8937918350714903`*^9, 3.8937918756665773`*^9}, {
   3.89379191255937*^9, 3.89379192541857*^9}, 3.8937920126776114`*^9, 
   3.893792157803134*^9, 3.893792458346753*^9, 3.8937925501201973`*^9},
 CellLabel->
  "Out[303]=",ExpressionUUID->"298fe07e-9021-45f7-a333-9fab47f47ea0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"gb", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "->", "1"}], ",", 
          RowBox[{"j", "->", "2"}], ",", 
          RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", "piRules"}], 
     ")"}], "//", "Simplify"}], "//", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         SubscriptBox["f", 
          RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
        RowBox[{"1", "-", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
          ")"}]}]}], "}"}]}], ")"}], "&"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.893792052269854*^9, 3.89379206669692*^9}, 
   3.893792170166246*^9, {3.8937924476689663`*^9, 3.8937924491139183`*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"fa03b6fd-bedf-414f-9ce4-1b3d2de67bca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[Pi]", 
     RowBox[{"1", ",", "\[Beta]"}]]}], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"2", ",", "\[Alpha]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}]], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"2", ",", "\[Beta]"}]]}]}]], "Output",
 CellChangeTimes->{{3.893792053816389*^9, 3.893792067720551*^9}, 
   3.893792172677496*^9, 3.893792451279315*^9},
 CellLabel->
  "Out[301]=",ExpressionUUID->"35a137ce-b636-408e-8d58-1a9d87227662"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"gb", "[", 
         RowBox[{"[", "8", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "->", "1"}], ",", 
          RowBox[{"j", "->", "2"}], ",", 
          RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", 
      RowBox[{"Join", "[", 
       RowBox[{"piRules", ",", "gammaRules"}], "]"}]}], ")"}], "//", 
    "Simplify"}], "//", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         SubscriptBox["f", 
          RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
        RowBox[{"1", "-", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
          ")"}]}]}], "}"}]}], ")"}], "&"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.893792204926125*^9, 3.89379220571448*^9}, {
  3.893792236284185*^9, 3.893792268567882*^9}, {3.893792441197908*^9, 
  3.893792442525082*^9}},
 CellLabel->
  "In[300]:=",ExpressionUUID->"dbc867b8-8c9a-47d3-aa73-059b49d67a3b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[Pi]", 
     RowBox[{"1", ",", "\[Alpha]"}]]}], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"2", ",", "\[Beta]"}]]}], "-", 
  SubscriptBox["\[Gamma]", 
   RowBox[{"1", ",", "2", ",", "\[Beta]"}]], "+", 
  RowBox[{
   SubscriptBox["P", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Gamma]", 
       RowBox[{"1", ",", "2", ",", "\[Alpha]"}]]}], "+", 
     SubscriptBox["\[Gamma]", 
      RowBox[{"1", ",", "2", ",", "\[Beta]"}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.89379221176658*^9, 3.893792270202894*^9, 
  3.893792443964727*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"fba9f687-3415-4e3b-94f8-87d7ae30af9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"gb", "[", 
          RowBox[{"[", "9", "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "->", "1"}], ",", 
           RowBox[{"j", "->", "2"}], ",", 
           RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", 
       RowBox[{"Join", "[", 
        RowBox[{"piRules", ",", "gammaRules"}], "]"}]}], ")"}], "//", 
     "Simplify"}], "//", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
         
         RowBox[{"1", "-", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
           ")"}]}]}], "}"}]}], ")"}], "&"}]}], "//", "Simplify"}], "//", 
  "Factor"}]], "Input",
 CellChangeTimes->{{3.8938101728114433`*^9, 3.89381017370278*^9}, {
  3.893810226764633*^9, 3.893810228827539*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"7b649e60-1e27-4c0e-b181-5aeb163eab81"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}], "2"], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"2", ",", "\[Beta]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}]], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Beta]"}]], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"2", ",", "\[Beta]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Beta]"}]], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "2", ",", "\[Alpha]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}]], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "2", ",", "\[Beta]"}]]}]}]], "Output",
 CellChangeTimes->{3.893810175669174*^9, 3.893810229812571*^9},
 CellLabel->
  "Out[305]=",ExpressionUUID->"01653336-d30f-4edd-b760-91974f4ab4db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"gb", "[", 
         RowBox[{"[", "11", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "->", "1"}], ",", 
          RowBox[{"j", "->", "2"}], ",", 
          RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", 
      RowBox[{"Join", "[", 
       RowBox[{"piRules", ",", "gammaRules"}], "]"}]}], ")"}], "//", 
    "Simplify"}], "//", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         SubscriptBox["f", 
          RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
        RowBox[{"1", "-", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
           SubscriptBox["f", 
            RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
          ")"}]}]}], "}"}]}], ")"}], "&"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.893792356694718*^9, 3.8937923574411182`*^9}, {
  3.893792434051805*^9, 3.893792435604146*^9}},
 CellLabel->
  "In[299]:=",ExpressionUUID->"087044a4-2011-47f3-a02d-f04d83c407f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Pi]", 
      RowBox[{"2", ",", "\[Alpha]"}]], "+", 
     SubscriptBox["\[Pi]", 
      RowBox[{"2", ",", "\[Beta]"}]]}], ")"}], " ", 
   SubscriptBox["\[Pi]", 
    RowBox[{"3", ",", "\[Beta]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"3", ",", "\[Beta]"}]], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "2", ",", "\[Alpha]"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"3", ",", "\[Alpha]"}]], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "2", ",", "\[Beta]"}]]}]}]], "Output",
 CellChangeTimes->{3.893792365242062*^9, 3.893792437659758*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"4f6e4dc2-91ae-41d5-b7d6-0eddf0ca373d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"gb", "[", 
          RowBox[{"[", "20", "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "->", "1"}], ",", 
           RowBox[{"j", "->", "2"}], ",", 
           RowBox[{"k", "->", "3"}]}], "}"}]}], ")"}], "/.", 
       RowBox[{"Join", "[", 
        RowBox[{"piRules", ",", "gammaRules"}], "]"}]}], ")"}], "//", 
     "Simplify"}], "//", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          SubscriptBox["f", 
           RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Beta]"}]], ")"}], "->", 
         
         RowBox[{"1", "-", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Alpha]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Alpha]", ",", "\[Beta]"}]], "+", 
            SubscriptBox["f", 
             RowBox[{"\[Beta]", ",", "\[Beta]", ",", "\[Alpha]"}]]}], 
           ")"}]}]}], "}"}]}], ")"}], "&"}]}], "//", "Simplify"}], "//", 
  RowBox[{
   RowBox[{"-", "#"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.893811464464074*^9, 3.893811465444643*^9}, {
  3.893811646992613*^9, 3.8938116502800007`*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"a8c04aad-a66e-4213-893e-0a201ec529e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[Gamma]", 
     RowBox[{"1", ",", "2", ",", "\[Beta]"}]]}], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "3", ",", "\[Alpha]"}]]}], "-", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Alpha]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["\[Pi]", 
        RowBox[{"3", ",", "\[Beta]"}]]}], " ", 
      SubscriptBox["\[Gamma]", 
       RowBox[{"1", ",", "2", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Pi]", 
       RowBox[{"2", ",", "\[Beta]"}]], " ", 
      SubscriptBox["\[Gamma]", 
       RowBox[{"1", ",", "3", ",", "\[Alpha]"}]]}]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["\[Pi]", 
    RowBox[{"1", ",", "\[Beta]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["\[Pi]", 
        RowBox[{"3", ",", "\[Beta]"}]]}], " ", 
      SubscriptBox["\[Gamma]", 
       RowBox[{"1", ",", "2", ",", "\[Alpha]"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Pi]", 
       RowBox[{"2", ",", "\[Beta]"}]], " ", 
      SubscriptBox["\[Gamma]", 
       RowBox[{"1", ",", "3", ",", "\[Alpha]"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "2", ",", "\[Alpha]"}]], " ", 
   SubscriptBox["\[Gamma]", 
    RowBox[{"1", ",", "3", ",", "\[Beta]"}]]}]}]], "Output",
 CellChangeTimes->{3.893811469652432*^9, 3.8938116537729683`*^9},
 CellLabel->
  "Out[307]=",ExpressionUUID->"c227fb19-9299-48a4-88f7-c46c23a4ff6c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1341, 904},
WindowMargins->{{28, Automatic}, {1, Automatic}},
FrontEndVersion->"13.2 for Mac OS X ARM (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b0a9af63-2926-4998-9e44-149c0a2619fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 189, 3, 123, "Title",ExpressionUUID->"23fbb238-f20f-4269-bc9e-d420ab787d81"],
Cell[CellGroupData[{
Cell[794, 29, 149, 3, 84, "Section",ExpressionUUID->"a79e920b-c85e-4532-8b4d-16acf791b01d"],
Cell[946, 34, 3688, 93, 69, "Input",ExpressionUUID->"9b7d7b58-de68-45f8-97ae-e91eb0a67a63"],
Cell[4637, 129, 8854, 207, 214, "Input",ExpressionUUID->"48031b9d-5bc7-4b9f-925e-376a2146d6d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13528, 341, 167, 3, 84, "Section",ExpressionUUID->"e642675d-1eaa-4422-99a7-19fe2369390b"],
Cell[13698, 346, 21834, 591, 501, "Input",ExpressionUUID->"ff1cdb4a-bef4-463d-99b9-15de8893eace"],
Cell[CellGroupData[{
Cell[35557, 941, 875, 27, 67, "Input",ExpressionUUID->"c0141e08-6f5d-416f-8b26-17027638d8e2"],
Cell[36435, 970, 1372, 35, 45, "Output",ExpressionUUID->"52426856-62d5-4ae0-88bb-885cca24d821"]
}, Open  ]],
Cell[37822, 1008, 497, 9, 102, "Text",ExpressionUUID->"1de82b06-e3fd-4854-94b2-8490ed1942a9"],
Cell[38322, 1019, 4114, 90, 220, "Input",ExpressionUUID->"9da651d8-13a7-414f-9b92-f18c41764e67"],
Cell[CellGroupData[{
Cell[42461, 1113, 532, 12, 90, "Input",ExpressionUUID->"4b5be177-5eb9-4ff6-9d5e-a4c935419430"],
Cell[42996, 1127, 209, 5, 42, "Output",ExpressionUUID->"c0b7fb26-eb30-4467-b1d3-42e3ba87eb14"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43242, 1137, 204, 4, 37, "Input",ExpressionUUID->"f95eb373-67d4-4b4b-87ee-65fd83b50f96"],
Cell[43449, 1143, 156, 3, 42, "Output",ExpressionUUID->"1b973c94-6649-4c4e-8f69-c4106b181967"]
}, Open  ]],
Cell[43620, 1149, 188, 3, 44, "Text",ExpressionUUID->"ea07b63c-b7e0-4216-95c5-af7e866d48f9"],
Cell[CellGroupData[{
Cell[43833, 1156, 675, 20, 40, "Input",ExpressionUUID->"98b31c71-561a-4fcd-b911-25ca997892a1"],
Cell[44511, 1178, 17291, 471, 825, "Output",ExpressionUUID->"9f105b17-fc2f-485f-af70-3c9536916494"]
}, Open  ]],
Cell[61817, 1652, 264, 6, 44, "Text",ExpressionUUID->"14c37b8e-4510-4f13-bc06-0bb6a6ca61bc"],
Cell[CellGroupData[{
Cell[62106, 1662, 203, 4, 37, "Input",ExpressionUUID->"2724c8a2-ee87-4956-80ef-fa51ca5545bb"],
Cell[62312, 1668, 916, 22, 45, "Output",ExpressionUUID->"f4e4bc8b-f51d-40af-bd63-7c74e4784518"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63277, 1696, 277, 6, 84, "Section",ExpressionUUID->"599ab672-280b-42aa-ac31-29c2081b46f4"],
Cell[CellGroupData[{
Cell[63579, 1706, 1824, 47, 66, "Input",ExpressionUUID->"34b61a66-d642-4a88-b0a0-dbf2820bcd62"],
Cell[65406, 1755, 630, 16, 45, "Output",ExpressionUUID->"298fe07e-9021-45f7-a333-9fab47f47ea0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66073, 1776, 1738, 45, 66, "Input",ExpressionUUID->"fa03b6fd-bedf-414f-9ce4-1b3d2de67bca"],
Cell[67814, 1823, 548, 16, 45, "Output",ExpressionUUID->"35a137ce-b636-408e-8d58-1a9d87227662"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68399, 1844, 1831, 48, 66, "Input",ExpressionUUID->"dbc867b8-8c9a-47d3-aa73-059b49d67a3b"],
Cell[70233, 1894, 737, 22, 45, "Output",ExpressionUUID->"fba9f687-3415-4e3b-94f8-87d7ae30af9f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71007, 1921, 1868, 50, 66, "Input",ExpressionUUID->"7b649e60-1e27-4c0e-b181-5aeb163eab81"],
Cell[72878, 1973, 881, 26, 47, "Output",ExpressionUUID->"01653336-d30f-4edd-b760-91974f4ab4db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73796, 2004, 1786, 47, 66, "Input",ExpressionUUID->"087044a4-2011-47f3-a02d-f04d83c407f4"],
Cell[75585, 2053, 837, 25, 45, "Output",ExpressionUUID->"4f6e4dc2-91ae-41d5-b7d6-0eddf0ca373d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76459, 2083, 1899, 51, 66, "Input",ExpressionUUID->"a8c04aad-a66e-4213-893e-0a201ec529e5"],
Cell[78361, 2136, 1553, 47, 45, "Output",ExpressionUUID->"c227fb19-9299-48a4-88f7-c46c23a4ff6c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

