# execute experiments with different parameter values with subprocess
import subprocess
import argparse

#get sigma as argument
parser = argparse.ArgumentParser()
parser.add_argument("--distance", default=None, type=str, help="L2 or Linf", choices=["L2", "Linf"])
parser.add_argument("--n_dup", default=None, type=int, help="number of markov chains")
parser.add_argument("--make_deterministic", default=False, action="store_true", help="make markov chains deterministic")
args = parser.parse_args()

#command looks like this: python code/basis_experiments.py cifar10 $model 0.5 5dims_9bins.csv --skip 1 --batch 1600 --num_bins 9 --num_basis 5
distances = [args.distance] if args.distance is not None else ["L2", "Linf"]
n_dups = [args.n_dup] if args.n_dup is not None else [1,2,5,10]
make_deterministic = args.make_deterministic


#command looks like this: python attack_model.py --start_batch 0 --end_batch 6 --load_path models/CIFAR10_MODEL.pt --exp_name rerun_ebm_1_step_5_dup_l2_no_sigma_REDO --n_steps_refine 1 --distance L2 --random_init --n_dup_chains 5 --sigma 0.0 --base_dir adv_results_determ

for distance in distances:
# for distance in ["L2"]:
    for n_dup in n_dups:
    # for n_dup in [1]:
        # for make_deterministic in [False, True]:            
        # for make_deterministic in [False]:            
        exp_name = "ebm_1step_{}dup_{}_{}".format(n_dup, distance, "03sigma") + ("_determ" if make_deterministic else "")
        command = ["python", "attack_model.py", "--start_batch", "0", "--end_batch", "6", \
                    "--load_path", "models/CIFAR10_MODEL.pt", "--exp_name", exp_name,  \
                    "--n_steps_refine", "1", "--distance", distance, "--random_init", \
                    "--n_dup_chains", str(n_dup), "--sigma", "0.03", "--base_dir", "adv_results_determ", \
                    "--n_pgd_repeats", "1"
                    ]
        if make_deterministic:
            command.append("--make_deterministic")
        print(command)
        subprocess.check_output(command)
