def prompt_without_history_v0(init_block, target_block):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v1(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is non-zero and high. If the reward is zero or low, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v1(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v2(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v2(init_block, target_block, history=None):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt

def prompt_with_history_v5(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v5(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt
    
    
    
    
    

def prompt_with_history_v6(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'. Output your answer in the following format- step 1: {{}}\nstep 2: {{}} ...

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt

def prompt_without_history_v6(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt
    
    
def prompt_with_history_v7(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block
    END

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block
    END

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block
    END

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'. Output your answer in the following format- step 1: {{}}\nstep 2: {{}} ...

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """

    return prompt

def prompt_without_history_v7(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block
    END

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block
    END

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block
    END

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v4(init_block, target_block, history, step_seq, ns):
    
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Complete the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, generate a new action.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:{step_seq}step {ns}:"""
    return prompt

def prompt_without_history_v4(init_block, target_block, history, step_seq, ns):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:{step_seq}step {ns}:"""
    return prompt


def prompt_with_history_v2_llama(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up a block on top of the table
    - put down a block on top of the table
    - stack a block on top of another block
    - unstack a block from on top of the another block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below. 
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. 
    Note- Choose a step OPTIONS only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$' instead generate a alternate step.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v2_llama(init_block, target_block):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below. 
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """

def prompt_with_history_v2_llama_v1(init_block, target_block, history):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    In EXAMPLE 4 below, follow the SOLUTION and select each step only if it corresponds to a HIGH reward in OPTIONS. In case the reward is assessed as LOW, refrain from outputting the respective step and generate an alternative step in the SOLUTION instead.
    [OPTIONS] 
    {history}

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt

def prompt_with_history_v2_llama_v1_1(init_block, target_block, history):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    For "[SOLUTION]" of "[PROBLEM 4]" below, output a step ONLY IF it has HIGH reward in "[OPTIONS]". If a step has LOW reward, strictly DO NOT output the respective step.
    [OPTIONS] 
    {history}

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt


def prompt_without_history_v2_llama_v1(init_block, target_block):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block 

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt

def prompt_with_history_v2_llama_v2(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. The game is to transform blocks from "[INITIAL BLOCK SETUP]" to "[TARGET BLOCK SETUP]" by using relevant steps from the following:
    - pick up a block 
    - unstack a block from on top of another block 
    - put down a block 
    - stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    In EXAMPLE 4 below, follow the SOLUTION and select each step only if it corresponds to a HIGH reward in OPTIONS. In case the reward is assessed as LOW, refrain from outputting the respective step and generate an alternative step in the SOLUTION instead.
    [OPTIONS] 
    {history}

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt

def prompt_without_history_v2_llama_v2(init_block, target_block):
    prompt = f"""
    A block game is being played. Each block is represented by a color. The game is to transform blocks from "[INITIAL BLOCK SETUP]" to "[TARGET BLOCK SETUP]" by using relevant steps from the following:
    - pick up a block 
    - unstack a block from on top of another block 
    - put down a block 
    - stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt


def prompt_with_history_v2_llama_v1_1_with_instruct(init_block, target_block, history):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    For "[SOLUTION]" of "[PROBLEM 4]" below, output a step ONLY IF it has HIGH reward in "[OPTIONS]". If a step has LOW reward, strictly DO NOT output the respective step.
    [OPTIONS] 
    {history}

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt


def prompt_without_history_v2_llama_v1_with_instruct(init_block, target_block):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block 

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt



def prompt_with_history_v2_llama_v1_1_options(init_block, target_block, history):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    For "[SOLUTION]" of "[PROBLEM]" below, output a step ONLY IF it has HIGH reward in "[OPTIONS]". If a step has LOW reward, strictly DO NOT output the respective step. Instead generate a new step based on the instructions provided above.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [OPTIONS]
    Possible options for step 1 and expected rewards:
    pick yellow block from on top of table has LOW reward
    unstack the orange block from on top of the blue block has HIGH reward
    stack based action has HIGH reward
    put based action has HIGH reward

    Possible options for step 2 and expected rewards:
    pick yellow block from on top of table has LOW reward
    unstack the orange block from on top of the blue block has LOW reward
    stack based action has HIGH reward
    put based action has HIGH reward
    
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [OPTIONS]
    Possible options for step 1 and expected rewards:
    pick yellow block from on top of table has LOW reward
    unstack the orange block from on top of the blue block has LOW reward
    unstack the yellow block from on top of the blue block HIGH reward
    put based action has HIGH reward

    Possible options for step 2 and expected rewards:
    pick based action has HIGH reward
    unstack the orange block from on top of the blue block has LOW reward
    stack based action has HIGH reward
    put based action has HIGH reward

    Possible options for step 3 and expected rewards:
    pick yellow block from on top of table has LOW reward
    unstack the orange block from on top of the blue block has LOW reward
    unstack the blue block from on top of the orange block has LOW reward
    unstack the yellow block from on top of the blue block has LOW reward
    stack based action has HIGH reward
    put based action has HIGH reward

    Possible options for step 4 and expected rewards:
    stack the blue block on top of the yellow block has LOW reward
    unstack the orange block from on top of the blue block has LOW reward
    pick based action has HIGH reward
    put based action has HIGH reward
    
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [OPTIONS]
    Possible options for step 1 and expected rewards:
    unstack the orange block from on top of the red block has LOW reward
    unstack the orange block from on top of the blue block has LOW reward
    stack based action has HIGH reward
    put based action has HIGH reward

    Possible options for step 2 and expected rewards:
    put based action has HIGH reward
    unstack the orange block from on top of the blue block has LOW reward
    stack based action has HIGH reward
    pick based action has HIGH reward

    Possible options for step 3 and expected rewards:
    pick yellow block from on top of table has LOW reward
    stack the orange block from on top of the blue block has LOW reward
    stack the blue block from on top of the orange block has LOW reward
    stack the yellow block from on top of the blue block has LOW reward
    unstack based action has HIGH reward
    put based action has HIGH reward

    Possible options for step 4 and expected rewards:
    put based action has HIGH reward
    unstack the orange block from on top of the blue block has LOW reward
    pick based action has HIGH reward
    stack based action has HIGH reward

    Possible options for step 5 and expected rewards:
    pick up the yellow block has LOW reward
    put based action has HIGH reward
    stack based action has HIGH reward
    unstack based action has HIGH reward

    Possible options for step 6 and expected rewards:
    stack the yellow block on top of the orange block has LOW reward
    stack the reb block on top of blue blue block has LOW reward
    unstack based action has HIGH reward
    pick up the yellow block has LOW reward
    put based action has HIGH reward
    
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [OPTIONS] 
    {history}
    
    [SOLUTION]
    step 1:"""
    return prompt


def prompt_without_history_v2_llama_v1_options(init_block, target_block):
    prompt = f"""
    I am playing with a set of blocks where I need to arrange the blocks into stacks. Each step in the [SOLUTION] should be based on one of the following:
    
    - Pick up a block 
    - Unstack a block from on top of another block 
    - Put down a block 
    - Stack a block on top of another block 

    I have the following restrictions on my steps:
    I can only pick up or unstack one block at a time. 
    I can only pick up or unstack a block if my hand is empty. 
    I can only pick up a block if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it and if the block is not picked up. 
    I can only unstack a block from on top of another block if the block I am unstacking was really on top of the other block. 
    I can only unstack a block from on top of another block if the block I am unstacking is clear. Once I pick up or unstack a block, I am holding the block. 
    I can only put down a block that I am holding. 
    I can only stack a block on top of another block if I am holding the block being stacked. 
    I can only stack a block on top of another block if the block onto which I am stacking the block is clear. Once I put down or stack a block, my hand becomes empty.

    [PROBLEM 1]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table 
    [TARGET BLOCK SETUP] the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block
    [SOLUTION]
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    [PROBLEM 2]
    [INITIAL BLOCK SETUP] the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table
    [TARGET BLOCK SETUP] the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block
    [SOLUTION]
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    [PROBLEM 3]
    [INITIAL BLOCK SETUP] the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table
    [TARGET BLOCK SETUP] the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table
    [SOLUTION]
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    [PROBLEM 4]
    [INITIAL BLOCK SETUP] {init_block}
    [TARGET BLOCK SETUP] {target_block}
    [SOLUTION]
    step 1:"""
    return prompt

