def prompt_without_history_v0(init_block, target_block):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v1(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is non-zero and high. If the reward is zero or low, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v1(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v2(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v2(init_block, target_block, history=None):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt

def prompt_without_history_v2_propose_prompt(init_block, target_block, y='[None]'):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Current Step sequence to transform Initial block setup to Target block setup:
    [None]
    
    Possible Next Steps are:
    step 1: unstack the orange block from on top of the blue block
    step 1: pick the yellow block
    step 1: unstack the blue block from on top of the red block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Current Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    
    Possible Next Steps are:
    step 3: pick the blue block
    step 3: unstack the yellow block on top of the blue block
    step 3: unstack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Current Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block

    Possible Next Steps are:
    step 3: unstack the red block from on top of the yellow block
    step 3: pick up the orange block
    step 3: unstack the orange block from on top of the yellow block
    
    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the Possible Next Steps that can be taken after Current Step sequence to transform Initial block setup to Target block setup for the following-
    Note: Strictly DO NOT produce/predict the same step more than once in the "Possible Next Steps are:" section. A step can utmost appear once only. Try to predict different variety of steps using 'unstack', 'stack', 'pick', and 'put'

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    {y}
    
    Possible Next Steps are:
    """
    return prompt


def prompt_without_history_v2_value_last_step_prompt(init_block, target_block, step_sequence):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Judge:
    sure

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the blue block on top of the yellow block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the yellow block on top of the orange block

    Judege:
    impossible

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Judge:
    sure

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    For the example provided below, If the Step sequence can be utilized to successfully convert the block form Initial block setup to the Target block setup, then output your answer as "sure" Otherwise, output your answer as "impossible"

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    {step_sequence}

    Judge:
    """
    return prompt




def prompt_with_history_v5(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...
    """
    return prompt

def prompt_without_history_v5(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt
    
    
    
    
    

def prompt_with_history_v6(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'. Output your answer in the following format- step 1: {{}}\nstep 2: {{}} ...

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt

def prompt_without_history_v6(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt
    
    
def prompt_with_history_v7(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block
    END

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block
    END

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block
    END

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, DO NOT output the respective step mentioned between the '$$$'. Output your answer in the following format- step 1: {{}}\nstep 2: {{}} ...

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """

    return prompt

def prompt_without_history_v7(init_block, target_block, history):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block
    END

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block
    END

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block
    END

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:
    """
    return prompt


def prompt_with_history_v4(init_block, target_block, history, step_seq, ns):
    
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Complete the step sequence to transform Initial block setup to Target block setup for the example below-
    For each step in Step sequence, select the step from OPTIONS provided between the symbols '$$$'. Choose a step only if the reward is HIGH. If the reward is LOW, generate a new action.

    OPTIONS
    $$$
    {history}
    $$$

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:{step_seq}step {ns}:"""
    return prompt

def prompt_without_history_v4(init_block, target_block, history, step_seq, ns):
    prompt = f"""
    A block game is being played. Each block is represented by a color. At any given point, one single action\
    can be performed on one block, this results in change in block setup.

    Possible steps on the block setup:
    @@@
    - pick up the {{}} block from on top of the table
    - put down the {{}} block on top of the table
    - stack the {{}} block on top of the {{}} block
    - unstack the {{}} block from on top of the {{}} block
    @@@

    Rules to execute an action on the block setup:
    &&&
    1. pick up or unstack should be performed on one block at a time
    2. pick up or unstack should be performed only if hand is empty
    3. pick up should be performed only if the block is on the table and the block is clear. A block is clear if the block has no other blocks on top of it.
    4. unstack should be performed only if the block being unstacked is on top of the other block and no \
    block is on top of the block being unstacked.
    5. unstack should be performed only if the block I am unstacking is clear. A block is clear if the block has no other blocks on top of it.
    6. put action should be performed only if the block being put is in the hand
    7. put action cannot be performed if hand is empty
    8. stack action should be performed only if the block being stacked is in the hand
    9. stack action should be performed only if the block being stacked is in hand and the other block is clear
    10. if a block is in the hand, then pick or unstack action cannot be performed
    &&&

    Example 1:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the orange block is on top of the blue block, the red block is on the table and the yellow block is on the table    

    Target block setup:
    the blue block is clear, the yellow block is on the table, the orange block is on top of the yellow block, the hand is empty, the red block is on the table, the blue block is on top of the red block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the blue block
    step 2: stack the orange block on top of the yellow block

    Example 2:
    Initial block setup:
    the orange block is clear, the yellow block is clear, the hand is empty, the blue block is on top of the red block, the yellow block is on top of the blue block, the red block is on the table and the orange block is on the table

    Target block setup:
    the orange block is on the table, the blue block is clear, the red block is clear, the blue block is on top of the yellow block, the hand is empty, the red block is on the table, the yellow block is on top of the orange block

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the yellow block from on top of the blue block
    step 2: stack the yellow block on top of the orange block
    step 3: unstack the blue block from on top of the red block
    step 4: stack the blue block on top of the yellow block

    Example 3:
    Initial block setup:
    the orange block is clear, the hand is empty, the red block is on top of the yellow block, the orange block is on top of the red block, the yellow block is on top of the blue block and the blue block is on the table

    Target block setup:
    the yellow block is on top of the blue block, the red block is on the table, the red block is clear, the orange block is clear, the orange block is on top of the yellow block, the hand is empty, the blue block is on the table

    Step sequence to transform Initial block setup to Target block setup:
    step 1: unstack the orange block from on top of the red block
    step 2: put down the orange block
    step 3: unstack the red block from on top of the yellow block
    step 4: put down the red block
    step 5: pick up the orange block
    step 6: stack the orange block on top of the yellow block

    Based on the rules described between symbols '&&&' and possible steps described between '@@@'.
    Predict the step sequence to transform Initial block setup to Target block setup for the example below-
    Output your answer in the following format step 1: {{}}\nstep 2: {{}} ...

    Initial block setup:
    {init_block}

    Target block setup:
    {target_block}

    Step sequence to transform Initial block setup to Target block setup:{step_seq}step {ns}:"""
    return prompt


def prompt_with_history_gsm8k_propose(question, history='[None]'):
    prompt=f"""
    Solve the given arithmetic problem step-by-step and arrive at the final answer.

    Problem 1:
    Brenda invested $300 into a scheme that accumulates simple interest at the rate of three-quarters of the original amount per year. How much in total will she have after 3 years?

    Solution for Problem 1:
    [None]
     
    Possible next steps to solve Problem 1:
    step 1: Three-quarters of $300 is (3/4)*$300 = $225
    step 1: After 3 years she will have no money left.
    step 1: She now has a total of $300+$675 = $975 
    

    Problem 2:
    An airport has only 2 planes that fly multiple times a day. Each day, the first plane goes to Greece for three-quarters of its flights, and the remaining flights are split equally between flights to France and flights to Germany. The other plane flies exclusively to Poland, and its 44 trips only amount to half the number of trips the first plane makes throughout each day. How many flights to France does the first plane take in one day?

    Solution for Problem 2:
    step 1: The second plane flies half as much as the first, so the first plane makes 44 flights * 2 = 88 flights a day. 
    step 2: If 3/4 of the first plane’s flights are to Greece, then flights to France or Germany make up 1 – 3/4 = 1/4 of the total daily flights. 

    Possible next steps to solve Problem 2:
    step 3: Therefore, 88 daily flights / 4 = 22 flights to France or Germany. 
    step 3: Therefore, 44 flights * 2 = 88 flights a day.
    step 3: Therefore, 88 daily flights * 3/4 = 66 flights to France or Germany. 

    Problem 3:
    200 pounds of carrots are to be distributed to 40 restaurants in a certain city. Each restaurant is to receive 2 pounds of carrots. How many pounds of carrots will not be used?

    Solution for Problem 3:
    step 1: The restaurants need 40 * 2 = 80 lbs. of carrots. 
    step 2: So 200 - 80 = 120 lbs. of carrots will not be used. 

    Possible next steps to solve Problem 3:
    final answer: 120 
    final answer: 0 
    final answer: 80 

    Based on the example Problem, Solution, and the Possible next steps provided above. Predict the Possible next steps and final answer for the below Problem 4. 


    
    Problem 4:
    {question}
    
    Solution for Problem 4:
    {history}

    Possible next steps to solve Problem 4:
    """
    
    return prompt

def prompt_with_history_gsm8k_value(question, history='[None]'):
    prompt=f"""
    Solve the given arithmetic problem step-by-step and arrive at the final answer.

    Problem 1:
    Brenda invested $300 into a scheme that accumulates simple interest at the rate of three-quarters of the original amount per year. How much in total will she have after 3 years?

    Solution for Problem 1:
    step 1: Three-quarters of $300 is (3/4)*$300 = $225 
    step 2: After 3 years, interest of $225*3 = $675 has been accumulated 
    step 3: She now has a total of $300+$675 = $975 
    final answer: 975
     
    Judge:
    sure 
    
    Problem 2:
    An airport has only 2 planes that fly multiple times a day. Each day, the first plane goes to Greece for three-quarters of its flights, and the remaining flights are split equally between flights to France and flights to Germany. The other plane flies exclusively to Poland, and its 44 trips only amount to half the number of trips the first plane makes throughout each day. How many flights to France does the first plane take in one day?

    Solution for Problem 2:
    step 1: The second plane flies half as much as the first, so the first plane makes 44 flights * 2 = 88 flights a day. 
    step 2: If 3/4 of the first plane’s flights are to Greece, then flights to France or Germany make up 1 – 3/4 = 1/4 of the total daily flights. 

    Judge:
    sure

    Problem 3:
    200 pounds of carrots are to be distributed to 40 restaurants in a certain city. Each restaurant is to receive 2 pounds of carrots. How many pounds of carrots will not be used?

    Solution for Problem 3:
    step 1: The restaurants need 40 * 2 = 80 lbs. of carrots. 
    step 2: So 200 - 80 = 120 lbs. of carrots will not be used. 
    final answer: 80 

    Judge:
    impossible

    Based on the example Problem, Solution, and the Possible next steps provided above. Predict Judge for the below Problem 4. If the Solution is consistent, logically, correct and has the potential to solve teh problem, then output your answer as "sure" Otherwise, output your answer as "impossible"

    
    Problem 4:
    {question}
    
    Solution for Problem 4:
    {history}

    Judge:
    """
    
    return prompt


    
    
    
    
    
    
    
    
    


    
    
    
    
    
    
    
    
    