dataset_parameters = {
    'mmnist': {
        'in_shape': [10, 1, 64, 64],
        'pre_seq_length': 10,
        'aft_seq_length': 10,
        'total_length': 20,
        'data_name': 'mnist',
        'metrics': ['mse', 'mae', 'ssim', 'psnr'],
    },
    'human': {
        'in_shape': [4, 3, 256, 256],
        'pre_seq_length': 4,
        'aft_seq_length': 4,
        'total_length': 8,
        'metrics': ['mse', 'mae', 'ssim', 'psnr', 'lpips'],
    },
    'kth': {
        'in_shape': [10, 1, 128, 128],
        'pre_seq_length': 10,
        'aft_seq_length': 20,
        'total_length': 30,
        'metrics': ['mse', 'mae', 'ssim', 'psnr', 'lpips'],
    },
    'kitticaltech': {
        'in_shape': [10, 3, 128, 160],
        'pre_seq_length': 10,
        'aft_seq_length': 1,
        'total_length': 11,
        'metrics': ['mse', 'mae', 'ssim', 'psnr', 'lpips'],
    },
    **dict.fromkeys(['weather', 'weather_t2m_5_625'], {  # 2m_temperature
        'in_shape': [12, 1, 32, 64],
        'pre_seq_length': 12,
        'aft_seq_length': 12,
        'total_length': 24,
        'data_name': 't2m',
        'train_time': ['2010', '2015'], 'val_time': ['2016', '2016'], 'test_time': ['2017', '2018'],
        'metrics': ['mse', 'rmse', 'mae'],
    }),
}