from sqlalchemy import ForeignKey, Integer
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.base import Base


class ApplicationAgent(Base):
    """
    This class represents an association between an agent and an application the agent was
    deployed to.
    """

    __tablename__ = "application_agent"
    __table_args__ = {
        "comment": "This table stores the association between applications and agents."
    }

    application_id: Mapped[int] = mapped_column(
        "application_id",
        Integer,
        ForeignKey("application.application_id"),
        primary_key=True,
        comment="ID of the application.",
    )
    agent_id: Mapped[int] = mapped_column(
        "agent_id",
        Integer,
        ForeignKey("agent.agent_id"),
        primary_key=True,
        comment="ID of the agent.",
    )
