from typing import Optional

from sqlalchemy import Boolean, ForeignKey, Integer, String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.application import Application


class Chat(Application):
    """
    This class represents general information about a chat application.
    """

    __tablename__ = "chat"
    __table_args__ = {"comment": "This table stores general information about a chat application."}

    application_id: Mapped[int] = mapped_column(
        "application_id",
        Integer,
        ForeignKey("application.application_id"),
        primary_key=True,
        comment="Sequential ID",
    )
    online: Mapped[bool] = mapped_column(
        "online", Boolean, comment="Whether the chat was recorded in an online manner or offline."
    )
    flagged: Mapped[bool] = mapped_column(
        "flagged", Boolean, comment="Flag indicating if the whole chat was reported."
    )
    flagging_comment: Mapped[Optional[str]] = mapped_column(
        "flagging_comment", String, comment="Reasons behind why the chat was flagged."
    )

    __mapper_args__ = {"polymorphic_identity": "chat"}
