from sqlalchemy import ForeignKey, Integer, String
from sqlalchemy.orm import Mapped, mapped_column

# Chat needs to be imported here to avoid NoReferencedTableError by SQLAlchemy.
# It is used in the code in a declarative manner, therefore the F401 code to ignore
# 'imported but unused' warnings by code linting.
from synthetic_agents.database.entity.chat import Chat  # noqa: F401
from synthetic_agents.database.entity.memory import Memory


class ChatMemory(Memory):
    """
    This class represents a memory of an agent.
    """

    __tablename__ = "chat_memory"
    __table_args__ = {"comment": "This table stores the chat memories of different agents."}

    memory_id: Mapped[str] = mapped_column(
        "memory_id",
        String,
        ForeignKey("memory.memory_id"),
        primary_key=True,
        comment="ID of the memory shared with the long-term storage (vector DB).",
    )
    chat_id: Mapped[int] = mapped_column(
        "application_id",
        Integer,
        ForeignKey("chat.application_id"),
        comment="ID of the application.",
    )
    session_id: Mapped[str] = mapped_column(
        "session_id",
        String,
        comment="ID of the chat session. Memories can be created in different sessions of the "
        "same chat.",
    )

    __mapper_args__ = {"polymorphic_identity": "chat"}
