from datetime import datetime

from sqlalchemy import DateTime, ForeignKey, Integer, String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.base import Base


class Memory(Base):
    """
    This class represents a memory of an agent.
    """

    __tablename__ = "memory"
    __table_args__ = {"comment": "This table stores the memories of different agents."}

    memory_id: Mapped[str] = mapped_column(
        "memory_id",
        String,
        primary_key=True,
        comment="ID of the memory shared with the long-term storage (vector DB).",
    )
    agent_id: Mapped[int] = mapped_column(
        "agent_id",
        Integer,
        ForeignKey("agent.agent_id"),
        comment="ID of the agent.",
    )
    creation_timestamp: Mapped[datetime] = mapped_column(
        "creation_timestamp", DateTime, comment="When the memory was produced and persisted."
    )
    memory_type: Mapped[str] = mapped_column("memory_type", String, comment="Type of the memory.")
    content: Mapped[str] = mapped_column(
        "content",
        String,
        comment="Textual content of the memory.",
    )

    __mapper_args__ = {"polymorphic_identity": "memory", "polymorphic_on": "memory_type"}
