from sqlalchemy import ForeignKey, String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.base import Base


class PromptTemplate(Base):
    """
    This class represents prompt template specific to some application and agent type.
    """

    __tablename__ = "prompt_template"
    __table_args__ = {
        "comment": "This table stores prompt templates used by the AI agents in different "
        "applications."
    }

    application_type: Mapped[str] = mapped_column(
        "application_type",
        String,
        primary_key=True,
        comment="Type of application the template was designed for.",
    )
    agent_type: Mapped[str] = mapped_column(
        "agent_type",
        String,
        ForeignKey("agent_type.type_id"),
        primary_key=True,
        comment="Type of agent the template was designed for.",
    )
    version: Mapped[str] = mapped_column(
        "version", String, primary_key=True, comment="Template version."
    )
    content: Mapped[str] = mapped_column(
        "content", String, comment="Textual content of the template."
    )
