from abc import ABC, abstractmethod
from typing import Dict, List, Optional, Union

from synthetic_agents.model.memory import Memory

SAMPLE_TYPE = Union[List[str], Dict[str, str], List[Memory]]


class Generator(ABC):
    """
    This class represents a text generator. Child classes of this one implement logics to
    randomly generate relevant textual data.
    """

    @abstractmethod
    def generate(self, num_samples: int, seed: Optional[int] = None) -> SAMPLE_TYPE:
        """
        Generates a list of textual data.

        :param num_samples: number of samples to generate.
        :param seed: random seed for reproducibility.
        :return: a list of randomly generated textual data.
        """
        pass
