# Synthetic AAI Chats

## Prerequisites

### Installation

If `poetry` is not already installed, run `brew install poetry` to do so. Alternatively,
you can install poetry with pip in your virtual environment.

We strongly recommend to create a virtual environment (using conda or pyenv, for instance) and 
follow the next steps on the active environment. Make sure the environment uses python 3.9.

Finally, install the project with `poetry`.
```
poetry install
```

### DB initialization

Initialize the DB to create the necessary tables and agent types.
```
make init_db
```

## AAI Chats

### Prompt template creation

Before putting the agents to talk, we need to create prompt templates they will use during the 
interview. To create a prompt template for a user, start the web interface we created with the 
command below:
```
make start_app
```

If not done automatically, open your browser and navigate to `localhost:8080` to see the page 
below.
![main_page.png](images/main_page.png)

Navigate to the **Prompt Template Builder** page, as shown below.
![prompt_template_creation_page.png](images/prompt_template_creation_page.png)

Select the agent type `User`, place the following text in the prompt template area and give the 
template a version name (e.g., 1.0.0).

```
You are an assistant impersonating a human with a given #PROFILE# chatting with another human.
You can use the events in #MEMORY# to talk about concrete experiences you lived.
Respond in a way that matches this description without explicitly saying the way you feel "{attachment_style_description}". You will be penalized if you mention any part of this description in your answer.
Your answer must be 1-paragraph long and you must not ask questions.

#PROFILE#
name: {name}
age: {age}
dob: {dob}
current occupation: {current_job}
birthplace: {birthplace}
children: {children}
siblings: {siblings}
places lived: {places_lived}
father's jobs: {fathers_jobs}
mothers's jobs: {mothers_jobs}

#MEMORIES#
{life_memories}

#CHAT HISTORY
{chat_history}
```

Now repeat the steps to create a prompt template or the `AAI Interviewer` agent (all agents need 
to be assigned a prompt template). However, you can leave the template empty or this agent since
it will ask pre-defined questions instead of generating them with an LLM. 

There's an extra agent type called `Human`, which you can use to chat with the `User` agent by
typing messages on the online chat page shown later.

### AAI interviewer creation

Navigate to the **Agent Builder** page as shown below.
![agent_creation_page.png](images/agent_creation_page.png)

Select the agent type `AAI Interviewer` and click on the 
`Create Agent` button in the bottom of the page. This will create an interviewer agent we will
use to pair up with our synthetic user agents. The interviewer agent does not need a user profile
or childhood memories.

One can also use this page to create user agents with random user profiles and life facts 
(childhood memories). However, we will do this in an offline manner and in bulk to save us time.

Note: If this is the first time you are creating an interviewer user, it should receive ID = 1. If 
this is not the case, copy the ID attributed to the new interviewer user (it shows up as a message 
on the screen) and change the next commands appropriately.

### Creating random users and chats

The next step is to create user agents with different profiles and childhood memories. Followed by 
assigning them to a chat with the AAI interviewer user. We can do this online using our web app or
offline and in bulk. Please follow the instructions in the `README.md` file of the 
`attachment_style` project to proceed with the latter.

To create chats in an online manner, navigate to the **Chat Builder** page as shown below:
![chat_creation_page.png](images/chat_creation_page.png)

To play previously created chat, navigate to the **Online Chat** page, as shown below:
![chat_page.png](images/chat_page.png)
