from dataclasses import dataclass


@dataclass
class MemoryConfig:
    """
    Container to store chat information pertaining to an agent's memory model calibration.
    """

    remember_previous_sessions: bool = None
    retrieve_chat_memories: bool = None
    memory_retrieval_capacity: int = None
    working_memory_capacity: int = None
    context_window_capacity: int = None
    memory_embedding_model_name: str = None


@dataclass
class LanguageConfig:
    """
    Container to store chat information pertaining to an agent's language model calibration.
    """

    chat_history_length: int = None
    temperature: float = None
    top_p: float = None
    llm_name: str = None
