from sqlalchemy import String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.base import Base


class AgentType(Base):
    """
    This class represents an agent type.
    """

    __tablename__ = "agent_type"
    __table_args__ = {"comment": "This table stores agent types."}

    type_id: Mapped[int] = mapped_column(
        "type_id",
        String,
        primary_key=True,
        comment="Agent type ID.",
    )
    description: Mapped[str] = mapped_column(
        "description", String, comment="Description of the type of the agent."
    )
