from datetime import datetime

from sqlalchemy import DateTime, ForeignKey, Integer, String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.base import Base


class ApplicationLog(Base):
    """
    This class represents a log produced by an application.
    """

    __tablename__ = "application_log"
    __table_args__ = {
        "comment": "This table stores system logs during the execution of an application."
    }

    application_id: Mapped[int] = mapped_column(
        "application_id",
        Integer,
        ForeignKey("application.application_id"),
        primary_key=True,
        comment="ID of the application.",
    )
    log_id: Mapped[int] = mapped_column(
        "log_id",
        String,
        primary_key=True,
        comment="ID of the log.",
    )
    category: Mapped[str] = mapped_column("category", String, comment="Category of the log.")
    message: Mapped[str] = mapped_column("message", String, comment="Logged message.")
    event_timestamp: Mapped[datetime] = mapped_column(
        "event_timestamp", DateTime, comment="When the log message was produced."
    )
