from sqlalchemy import inspect
from sqlalchemy.orm import DeclarativeBase, exc


class Base(DeclarativeBase):
    def __repr__(self) -> str:
        """
        Gets a textual representation of an ORM.

        :return: a textual representation of an ORM.
        """

        field_strings = []
        at_least_one_attached_attribute = False
        for attr in inspect(self.__class__).columns:
            if hasattr(self, attr.key):
                try:
                    value = getattr(self, attr.key)
                    field_strings.append(f"{attr.key}={value!r}")
                except exc.DetachedInstanceError:
                    field_strings.append(f"{attr.key}=DetachedInstanceError")
                else:
                    at_least_one_attached_attribute = True

        if at_least_one_attached_attribute:
            return f"<{self.__class__.__name__}({','.join(field_strings)})>"

        return f"<{self.__class__.__name__} {id(self)}>"
