from sqlalchemy import ForeignKey, String
from sqlalchemy.orm import Mapped, mapped_column

from synthetic_agents.database.entity.memory import Memory


class LifeMemory(Memory):
    """
    This class represents a memory of an agent.
    """

    __tablename__ = "life_memory"
    __table_args__ = {"comment": "This table stores the life memories of different agents."}

    memory_id: Mapped[str] = mapped_column(
        "memory_id",
        String,
        ForeignKey("memory.memory_id"),
        primary_key=True,
        comment="ID of the memory shared with the long-term storage (vector DB).",
    )

    __mapper_args__ = {"polymorphic_identity": "life"}
