from pkg_resources import resource_string


def load_prompt_template(asset_name: str, application: str) -> str:
    """
    Reads a prompt template from a .txt file to the memory.

    :param asset_name: name of the asset file without the .txt extension.
    :param application: application for which the prompt was designed.
    :return: a prompt template with placeholders surrounded by curly brackets
        (e.g. This is a {placeholder}).
    """
    source = f"asset/prompt/{application}/{asset_name}.txt"
    return resource_string("synthetic_agents", source).decode("utf-8")
