from unittest import TestCase

from synthetic_agents.generator.life_fact import LifeFactGenerator
from synthetic_agents.generator.user_profile import UserProfileGenerator


class TestGenerator(TestCase):
    def setUp(self) -> None:
        pass

    def tearDown(self) -> None:
        pass

    def test_random_user_profile(self):
        """
        Checks that we can generate user profiles.
        """
        profiles = UserProfileGenerator().generate(num_profiles=3)

        assert len(profiles) == 3

    def test_random_life_facts(self):
        """
        Checks that we can generate life facts for a given user profile.
        """

        user_profile = {
            "name": "Alex",
            "age": 18,
            "dob": "September 15, 2005",
            "race": "hispanic",
            "gender": "male",
            "current_job": "student",
            "birthplace": "Place 1",
            "children": "none",
            "siblings": "none",
            "places_lived": "Place 1, Place 7 and Place 10",
            "fathers_job": "police officer",
            "mothers_job": "nurse",
        }
        life_facts = LifeFactGenerator(user_profile=user_profile).generate(num_memories=3)

        assert len(life_facts) == 3
