% Show the construction result record table
Nqubit = 40;
Npath = 20;
load("R40.mat")
load("X40.mat")
err = 1-X.*exp(-1./R);
[minVals, rowInds] = min(err);
[minVal, colInd] = min(minVals);
rowInd = rowInds(colInd);
delete = [rowInd, colInd];

new_err = err;
new_err(delete,:) = 1;
new_err(:,delete) = 1;
while ~all(new_err(:) == 1)
    [minVals, rowInds] = min(new_err);
    [minVal, colInd] = min(minVals);
    rowInd = rowInds(colInd);
    delete = [delete, rowInd, colInd];
    new_err = err;
    new_err(delete,:) = 1;
    new_err(:,delete) = 1;
end

r_ent = zeros(1,Npath);
for i = 1:Npath
    r_ent(i)=R(delete(2*i-1),delete(2*i));
end

G0 = zeros(Nqubit, Nqubit);

rat = 2e5;
maxSize = 0;
aval = [];
flag3 = 0;
flag2 = 0;
flag = 0;
count = 0;
result = [];
while maxSize<30
    while flag2 == 0
        while flag == 0
            count = count + 1;
            for i = 1:Npath
                if rand<r_ent(i)/rat
                    r_ent(i) = 0;
                    aval = [aval, delete(2*i-1), delete(2*i)];
                    G0(delete(2*i-1), delete(2*i)) = 1;
                    G0(delete(2*i), delete(2*i-1)) = 1;
                    G1 = graph(G0);
                    [bin, sizes] = conncomp(G1);
                    maxSize = max(sizes);
                    err(delete(2*i-1), delete(2*i)) = 1;
                    err(delete(2*i), delete(2*i-1)) = 1;
                    result = [result;count,delete(2*i-1),delete(2*i),maxSize];
                    delete(2*i) = 0;
                    delete(2*i-1) = 0;
                    flag = 1;                  
                end
            end
        end
        new_err(aval,aval) = err(aval,aval);
        sub_G0 = G0(aval,aval);
        sub_G0(1:size(sub_G0,1)+1:end) = 1;
        isFullyConnected = all(sub_G0(:) == 1);
        flag = 0;
        if ~isFullyConnected
            flag2 = 1;
        end
    end
    
    while ~all(new_err(:) == 1)
        [minVals, rowInds] = min(new_err);
        [minVal, colInd] = min(minVals);
        rowInd = rowInds(colInd);
        G = graph(G0);
        [Path, D] = shortestpath(G, rowInd, colInd);
        if isempty(Path)
            index = find(delete == 0, 1);    
            delete(index) = rowInd;
            delete(index+1) = colInd;
            aval(aval == rowInd) = [];
            aval(aval == colInd) = [];
            new_err(rowInd,:) = 1;
            new_err(:,rowInd) = 1;
            new_err(colInd,:) = 1;
            new_err(:,colInd) = 1;
        else
            new_err(rowInd,colInd) = 1;
            new_err(colInd,rowInd) = 1;
        end
    end
    flag2 = 0;
    flag = 0;
    aval = [];
    for i = 1:Npath
        if delete(2*i-1)>0
            r_ent(i)=R(delete(2*i-1),delete(2*i));
        end
    end
end
%
G = graph(G0);
figure(1)
plot(G); % Plot the build
%% Plot the error accumulation in Matlab Figure2 (Fig3b in main paper), and cluster size accumulation in Matlab Figure3 (Fig3c in main paper)
figure(2)
e0 = zeros(1,count);
Nmax =zeros(1,count);
ri = 1;
for i = 1:count
    for j=1:max(size(result))
        ri = result(j,1);
        if i > ri
            e0(i) = e0(i) + 1 - X(result(j,2),result(j,3))*exp(-(i-ri)/3e7);
        end
    end
end
plot(e0,'k','LineWidth',2)
ylabel('\epsilon')
xlabel('Step')
tranline = [1 11 14 18 23 38]; %(Need change for interested cross section for graph building proces, which will show in Fig3a in the main text)
hold on
for i = 1:length(tranline)
    line([result(tranline(i),1),result(tranline(i),1)],[0 0.1],'Color','k')
end
set(gca,'FontSize',18)
set(gca,'Linewidth',2)

for j=1:max(size(result))-1
    Nmax(result(j,1):result(j+1,1))=result(j,4);
end
figure(3)
plot(Nmax,'b','LineWidth',2)
hold on
plot(min(Nmax,1./e0),'r','LineWidth',2)
hold off
ylabel('N')
xlabel('Step')
hold on
for i = 1:length(tranline)
    line([result(tranline(i),1),result(tranline(i),1)],[0 40],'Color','k')
end
set(gca,'FontSize',18)
set(gca,'Linewidth',2)
%% Plot the cluster building progress in Matlab Figure4 (Fig3a in main paper, 6 subfigures)
figure(4)
Gp = zeros(Nqubit, Nqubit);
for i = 1:40
    Gp(result(i,2), result(i,3)) = 1;
    Gp(result(i,3), result(i,2)) = 1;
    if i == 1
        G1 = Gp;
    end
    if i == 11
        G2 = Gp;
    end
    if i == 14
        G3 = Gp;
    end
    if i == 18
        G4 = Gp;
    end
    if i == 23
        G5 = Gp;
    end
    if i == 38
        G6 = Gp;
    end 
end

layout = zeros(40,2);
for i = 1:40
    layout(i,1)=cos(i*pi/20);
    layout(i,2)=sin(i*pi/20);
end

G1m = findM(G1); 
G2m = findM(G2); 
G3m = findM(G3); 
G4m = findM(G4); 
G5m = findM(G5); 
G6m = findM(G6); 

subplot(2,3,1)
G = graph(G1);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G1m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])
set(gca,'FontSize',60)

subplot(2,3,2)
G = graph(G2);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','k','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G2m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])
set(gca,'FontSize',18)

subplot(2,3,3)
G = graph(G3);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','k','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G3m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])

subplot(2,3,4)
G = graph(G4);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','k','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G4m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])

subplot(2,3,5)
G = graph(G5);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','k','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G5m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])

subplot(2,3,6)
G = graph(G6);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','k','linewidth',2, 'NodeColor', 'k');
pg.NodeLabel = {};
hold on
G = graph(G6m);
pg = plot(G, 'XData', layout(:,1), 'YData', layout(:,2),'EdgeColor','r','linewidth',2);
pg.NodeLabel = {};
connectedVertices = unique(G.Edges.EndNodes(:));
nodeColors = repmat([0, 0, 0], numnodes(G), 1);
nodeColors(connectedVertices, :) = repmat([1, 0, 0], length(connectedVertices), 1);
for i = 1:numnodes(G)
    scatter(layout(i,1), layout(i,2), 36, nodeColors(i,:), 'filled');
end
xticklabels([])
yticklabels([])
