figure(1)
hold on
load("rm0.mat")
load("gd0.mat")
load("tf0.mat")
edges = linspace(0,24,13);
histogram(rm0,'BinEdges',edges,'Normalization', 'probability','FaceColor',[0.5 0.5 0.5])
histogram(tf0,'BinEdges',edges,'Normalization', 'probability','FaceColor',[0.5 0 0],'FaceAlpha',0.3)
histogram(gd0,'BinEdges',edges,'Normalization', 'probability','FaceColor',[0 0.5 0],'FaceAlpha',0.3)


[values, edges] = histcounts(gd0, 'Normalization', 'cdf');
cdf_values = [0, values];
plot(edges, cdf_values, 'LineWidth', 2, 'Color',[0 0.5 0]);

[values, edges] = histcounts(rm0, 'Normalization', 'cdf');
cdf_values = [0, values];
plot(edges, cdf_values, 'LineWidth', 2, 'Color', [0 0 0]);

[values, edges] = histcounts(tf0, 'Normalization', 'cdf');
cdf_values = [0, values];
plot(edges, cdf_values, 'LineWidth', 2, 'Color',[0.5 0 0]);

set(gca,'FontSize',18)
set(gca,'Linewidth',2)
box on
ylabel('P')
xlim([0 25])