# From MNIST to ImageNet: Understanding the Scalability Boundaries of Differentiable Logic Gate Networks

This repository is based on a clone of the original [Difflogic repository](https://github.com/Felix-Petersen/difflogic/).  
It extends and adapts the codebase for our experiments and paper.

---

## Setup

We recommend running the code inside an **Apptainer/Singularity container** (see the `/singularity` folder for setup details).  

Our container is compiled for **Compute Capability 7.5 (Turing)** which for instance is an **RTX 2080 Ti GPU**. This can be changed in the `singularity/container.def` definition file.

---

## Repository Structure

- **`analysis/`**  
  Main analysis notebooks for creating plots, visualizations, and derived data used in the paper.

- **`data/`**  
  Datasets will be automatically downloaded or placed here.

- **`difflogic/`**  
  Original Difflogic code and implementation (unmodified clone of upstream).

- **`experiments/`**  
  Experiment configuration files used for running plots and producing numeric results in the paper.  
  *Each Python file can be run individually.*

- **`library/`**  
  Core pipeline of the project. Contains:  
  - Configuration files  
  - Dataset loading and preprocessing  
  - Model architectures  
  - Training logic and utilities  

- **`models/`**  
  Stores trained models, their `state_dict`, and the associated configuration files.

- **`results/`**  
  Numeric results of trained models (aggregated metrics, logs, etc.).

---

## Usage

1. Build and start the container (see `/singularity/container.def`).  
2. Prepare datasets (`data/` will be populated automatically).  
3. Run an experiment configuration file from `experiments/`.  
4. Analyze outputs using the notebooks in `analysis/`.

---

## Dependencies

All dependencies are defined in the container (`/singularity/container.def`), which ensures a fully reproducible environment.  

For convenience, we also provide a `requirements.txt` to install dependencies outside the container (e.g. in a virtual environment).

---

## Notes

- The codebase assumes execution from the **project root directory**.
- See the README.md in `experiments/` and `library/`.
- Model outputs, metrics, and plots are saved into their respective folders automatically.  

---

After completing the setup, you can get started in two ways:

### 1. Run the test notebook
For a quick environment check, open:

- **`difflogic_test.ipynb`**  
  Runs a minimal example and trains the MNIST baseline model.  
  Useful to verify that everything is working.

### 2. Run an experiment
For paper-related results, run one of the experiment scripts from the `experiments/` folder, e.g.:

```bash
python experiments/mnist_baseline.py

