# Analysis Folder

This folder contains scripts, notebooks, data, and plots used for the analysis and figures in the paper.

---

## Folder Overview

- **`ds_samples/`**  
  Visualized samples of the synthetic dataset.

- **`output_masking/`**  
  JSON files with performance development results across different values of  
  - τ (tau)  
  - dropout  
  - datasets  
  - metrics  

- **`plot_data/`**  
  CSV files containing preprocessed data for creating plots in TikZ/Overleaf.

- **`plots/`**  
  All plots generated for the paper.

---

## File Overview

- **`neuron_distribution.ipynb`**  
  Evaluates the output activation distribution by importing trained models and analyzing their output predictions.  
  *(Run from the project root directory.)*

- **`output_masking.ipynb`**  
  Generates performance data of the output layer with masked output neurons.

- **`plotting_report.ipynb`**  
  Main notebook for generating the paper’s plots.

- **`post_ffn.ipynb`**  
  Trains a feed-forward layer after the last DLGN layer.

- **`visualize_synthetic_sample.ipynb`**  
  Generates visualizations of samples from the synthetic dataset.

---

## Notes

- All notebooks assume the project is run from the **root directory**.  
- Generated figures and data are saved automatically into the appropriate subfolders.  
- For reproducibility, ensure required dependencies are installed.

