import torch

from library import load_datasets
from library import metrics
from library import misc
from library import model_io
from library import models
from library import results_json
from library import train
from library import baseline_configs
from library import configs
import matplotlib.pyplot as plt

datasets = {'cifar10': (configs.Dataset.CIFAR10, 10),
            'cifar100': (configs.Dataset.CIFAR100, 100),
            'mnist': (configs.Dataset.MNIST, 10), 
            'fmnist': (configs.Dataset.FMNIST, 10), 
            'kmnist': (configs.Dataset.KMNIST, 10), 
            'qmnist': (configs.Dataset.QMNIST, 10), 
            'emnist_letters': (configs.Dataset.EMNIST_LETTERS, 26), 
            'emnist_balanced': (configs.Dataset.EMNIST_BALANCED, 47)
}
runs = [
    [512],
    [512, 512],
    [1000, 100]
]

for ds in datasets.keys():
    for i, r in enumerate(runs):
        config = baseline_configs.Get_MNIST_Config()
    
        ############
        config.data_config.dataset = datasets[ds][0]
        config.data_config.num_classes = datasets[ds][1]
        config.model_config.num_neurons = 64000
        config.train_config.batch_size = 128
        config.test_config.batch_size = 128
        config.train_config.learning_rate = 0.01
        config.model_config.last_layer_neurons = (64000//datasets[ds][1]) * datasets[ds][1]
        if ds in ["cifar10", "cifar100"]:
            config.train_config.save_model_on = 'valid'
        else:
            config.train_config.save_model_on = 'bin'
        
        config.experiment_config.experiment_name = f"{ds}_ffn_layer_03_{i}"
    
        config.model_config.num_layers = 6
        
        config.train_config.extensive_eval = True
        config.train_config.eval_freq = 4
        config.train_config.num_epochs = 100
        config.train_config.extensive_eval_train = True
        config.test_config.extensive_eval_test = True
    
        config.model_config.distanceLayer = False
        config.model_config.use_mygroupsum = False
        config.model_config.use_groupsum = True
        config.model_config.full_ffn = False
        config.model_config.use_ffn = True
        config.model_config.used_ffn = r
        config.model_config.use_ffbinary = False
        ############
        
        model_config = config.model_config
        print(model_config)
        
        misc.set_seed(config.model_config.seed)
        
        train_loader, validation_loader, test_loader, bin_loader, test_bin_loader = load_datasets.load_dataset(config)
        network = models.create_model(config)
        
        loss_fn = torch.nn.CrossEntropyLoss()
        
        optimizer = torch.optim.Adam(network.parameters(), lr=config.train_config.learning_rate)
        
        if config.data_config.device == "cuda":
            network = network.cuda()
        
        results = results_json.ResultsJSON(config)
        train.train(model=network, 
            loss_fn=loss_fn, 
            optimizer=optimizer, 
            train_loader=train_loader, 
            validation_loader=validation_loader, 
            binarized_loader=bin_loader,
            test_loader=test_loader,
            test_loader_bin=test_bin_loader,
            results=results, 
            config=config)
        
        # model_io.save_model(network, config=config, model_path="./models/", model_name=config.experiment_config.experiment_name)
    
        # ==== FREE MEMORY ====
        del network
        del optimizer
        del train_loader
        del validation_loader
        del test_loader
        del bin_loader
        torch.cuda.empty_cache()
        import gc
        gc.collect()
        # ======================









