import json
import argparse

# May be used as a general utils file.

def load_json(file_path):
    """Load a JSON file and return its content."""
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            data = json.load(file)
        return data
    except Exception as e:
        print(f"Error loading JSON file: {e}")
        return None

def print_summary(data):
    """Prints a summary of the JSON content."""
    if isinstance(data, dict):
        print(f"JSON contains a dictionary with {len(data)} keys.")
        print(f"Keys: {list(data.keys())[:10]} ...")  # Show first 10 keys
    elif isinstance(data, list):
        print(f"JSON contains a list with {len(data)} items.")
        if len(data) > 0 and isinstance(data[0], dict):
            print(f"First item keys: {list(data[0].keys())[:10]} ...")
    else:
        print(f"JSON contains a {type(data).__name__}")

def pretty_print(data):
    """Pretty-prints JSON content."""
    print(json.dumps(data, indent=4, ensure_ascii=False))

def search_key(data, key):
    """Search for a specific key in the JSON data."""
    if isinstance(data, dict):
        return data.get(key, "Key not found")
    elif isinstance(data, list):
        return [item.get(key, "Key not found") for item in data if isinstance(item, dict)]
    return "Invalid JSON structure for key search"