# Experiments Overview

This folder contains experiment files with short descriptions of their purpose and goals.  
Some files may have been slightly altered due to reruns required by time constraints.

---

### Baselines
- `baseline_final.py`: Baseline for different datasets; used as a comparison for other experiments.  
- `ffn_baseline_final.py`: Baseline for MLP models with three different layer sizes (256, 512, 1024).

### Binary Classification
- `binary_no_groupsum_02.py`: Tests model behavior without a GroupSum layer, where each output logit is treated as its own loss measure.

### Custom Number of Classes
- `custom_num_classes_final_difflogic.py`: Combines different MNIST datasets into one with 67 classes. Trains DLGN models with various tau values.  
- `custom_num_classes_final_mlp.py`: Same combined dataset (67 classes), trained with MLP models of three layer sizes (256, 512, 1024).

### Tau Experiments
- `different_tau_final.py`: Results across datasets with varying tau values.  
- `synthetic_tau_dropout_XX.py`: Configurations for tau-dropout heatmap analysis.

### Output Layers
- `distance_output_final.py`: Trains models with varying tau using the Codebook output layer (full output dimension as encoding).  
- `distance2_01.py`: Uses a second version of the Codebook layer, reducing output dimension via GroupSum first.  
- `ffn_layer_03.py`: Appends different feed-forward networks to the output of the last LogicLayer.

### ImageNet
- `imagenet_num_classes_XX.py`: Configurations with varying classes, tau values, neurons per layer, and output layer dimension.  
- `imagenet_num_classes_final_mlp.py`: MLP comparison on different class counts in ImageNet-32.

### Synthetic Data
- `synthetic_harder_05.py`: MLP experiment on a custom synthetic dataset.  
- `synthetic_harder_difflogic_XX.py`: Configurations with varying training conditions (classes, tau, backbone sizes, output sizes).
