-- UMLS 2025AA Database Schema (Schema Only - No Data Loading)
-- This file creates the necessary tables for UMLS data without loading data

USE umls;

-- MRCONSO: Concepts and Sources
CREATE TABLE IF NOT EXISTS MRCONSO (
    CUI VARCHAR(8) NOT NULL,
    LAT VARCHAR(3) NOT NULL,
    TS VARCHAR(1) NOT NULL,
    LUI VARCHAR(10) NOT NULL,
    STT VARCHAR(3) NOT NULL,
    SUI VARCHAR(10) NOT NULL,
    ISPREF VARCHAR(1) NOT NULL,
    AUI VARCHAR(9) NOT NULL,
    SAUI VARCHAR(50),
    SCUI VARCHAR(100),
    SDUI VARCHAR(100),
    SAB VARCHAR(40) NOT NULL,
    TTY VARCHAR(20) NOT NULL,
    CODE VARCHAR(100) NOT NULL,
    STR VARCHAR(3000) NOT NULL,
    SRL VARCHAR(10) NOT NULL,
    SUPPRESS VARCHAR(1) NOT NULL,
    CVF VARCHAR(5),
    INDEX idx_mrconso_cui (CUI),
    INDEX idx_mrconso_sab (SAB),
    INDEX idx_mrconso_str (STR(255)),
    INDEX idx_mrconso_code (CODE),
    INDEX idx_mrconso_aui (AUI)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- MRDEF: Definitions
CREATE TABLE IF NOT EXISTS MRDEF (
    CUI VARCHAR(8) NOT NULL,
    AUI VARCHAR(9) NOT NULL,
    ATUI VARCHAR(11) NOT NULL,
    SATUI VARCHAR(50),
    SAB VARCHAR(40) NOT NULL,
    DEF TEXT NOT NULL,
    SUPPRESS VARCHAR(1) NOT NULL,
    CVF VARCHAR(5),
    INDEX idx_mrdef_cui (CUI),
    INDEX idx_mrdef_sab (SAB)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- MRHIER: Hierarchical Relationships
CREATE TABLE IF NOT EXISTS MRHIER (
    CUI VARCHAR(8) NOT NULL,
    AUI VARCHAR(9) NOT NULL,
    CXN VARCHAR(3) NOT NULL,
    PAUI VARCHAR(9),
    SAB VARCHAR(40) NOT NULL,
    RELA VARCHAR(100),
    PTR VARCHAR(1000),
    HCD VARCHAR(100),
    CVF VARCHAR(5),
    INDEX idx_mrhier_cui (CUI),
    INDEX idx_mrhier_sab (SAB),
    INDEX idx_mrhier_ptr (PTR(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- MRREL: Concept Relationships
CREATE TABLE IF NOT EXISTS MRREL (
    CUI1 VARCHAR(8) NOT NULL,
    AUI1 VARCHAR(9) NOT NULL,
    STYPE1 VARCHAR(50) NOT NULL,
    REL VARCHAR(4) NOT NULL,
    CUI2 VARCHAR(8) NOT NULL,
    AUI2 VARCHAR(9) NOT NULL,
    STYPE2 VARCHAR(50) NOT NULL,
    RELA VARCHAR(100),
    RUI VARCHAR(10) NOT NULL,
    SRUI VARCHAR(10),
    SAB VARCHAR(40) NOT NULL,
    SL VARCHAR(40) NOT NULL,
    DIR VARCHAR(1) NOT NULL,
    RG VARCHAR(10),
    SUPPRESS VARCHAR(1) NOT NULL,
    CVF VARCHAR(5),
    INDEX idx_mrrel_cui1 (CUI1),
    INDEX idx_mrrel_cui2 (CUI2),
    INDEX idx_mrrel_sab (SAB),
    INDEX idx_mrrel_rel (REL)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- MRSTY: Semantic Types
CREATE TABLE IF NOT EXISTS MRSTY (
    CUI VARCHAR(8) NOT NULL,
    TUI VARCHAR(4) NOT NULL,
    STN VARCHAR(100) NOT NULL,
    STY VARCHAR(100) NOT NULL,
    ATUI VARCHAR(11) NOT NULL,
    CVF VARCHAR(5),
    INDEX idx_mrsty_cui (CUI),
    INDEX idx_mrsty_tui (TUI)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- MRSAT: Attributes
CREATE TABLE IF NOT EXISTS MRSAT (
    CUI VARCHAR(8) NOT NULL,
    LUI VARCHAR(10) NOT NULL,
    SUI VARCHAR(10) NOT NULL,
    METAUI VARCHAR(10) NOT NULL,
    STYPE VARCHAR(50) NOT NULL,
    CODE VARCHAR(100) NOT NULL,
    ATUI VARCHAR(11) NOT NULL,
    SATUI VARCHAR(50),
    ATN VARCHAR(100) NOT NULL,
    SAB VARCHAR(40) NOT NULL,
    ATV TEXT,
    SUPPRESS VARCHAR(1) NOT NULL,
    CVF VARCHAR(5),
    INDEX idx_mrsat_cui (CUI),
    INDEX idx_mrsat_sab (SAB),
    INDEX idx_mrsat_atn (ATN)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create additional indexes for better performance
CREATE INDEX IF NOT EXISTS idx_mrconso_combined ON MRCONSO(CUI, SAB, TTY);
CREATE INDEX IF NOT EXISTS idx_mrdef_combined ON MRDEF(CUI, SAB);
CREATE INDEX IF NOT EXISTS idx_mrhier_combined ON MRHIER(CUI, SAB);
CREATE INDEX IF NOT EXISTS idx_mrrel_combined ON MRREL(CUI1, CUI2, SAB);

-- Grant permissions to the umls_user
GRANT ALL PRIVILEGES ON umls.* TO 'umls_user'@'%';
FLUSH PRIVILEGES; 