## Analysis

Our sampling scripts produce visualizations and some simple analysis in the Weights and Biases UI.

For more in-depth exploration, we provide an analysis notebook, adapted from that of [MDGen](https://github.com/bjing2016/mdgen).

First, add the details of the sampling runs to a CSV file `SAMPLE_RUNS_CSV`, following the structure of ['sample_runs.csv'].

Then, precompute analysis results with:
```bash
python analysis_sweep.py --csv [SAMPLE_RUNS_CSV] --experiment [EXPERIMENT] --output-dir [ANALYSIS_OUTPUT_DIR]
```

If you have SLURM:
```bash
sbatch analysis_sweep.sh --csv [SAMPLE_RUNS_CSV] --experiment [EXPERIMENT] --output-dir [ANALYSIS_OUTPUT_DIR]
```

Finally, run [`make_plots.ipynb`] to make plots for your chosen experiment.

For example, if we have details for our sampling runs at `sample_runs.csv`:
```txt
experiment,wandb_sample_run_path,reference,trajectory
Our_2AA,/wandb/path/to/sample,JAMUNReference_2AA,JAMUN
Our_2AA,/wandb/path/to/sample,JAMUNReference_2AA,JAMUN
Timewarp_2AA,/wandb/path/to/sample,TimewarpReference,JAMUN
...
```

We can run the analysis for `Timewarp_2AA` with:
```bash
python analysis_sweep.py --csv sample_runs.csv --experiment Timewarp_2AA --output-dir ./jamun-analysis/
```
