import os
import numpy as np
import torchvision.models as models
import torch
from torchvision import datasets, transforms
from torch.autograd import Variable
from torch.utils.data.dataloader import default_collate
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

adda='./Original_images/amazon/images/'
addd='./Original_images/dslr/images/'
addw='./Original_images/webcam/images/'

model = torch.hub.load('pytorch/vision:v0.6.0', 'vgg16', pretrained=True).to(device)
model.classifier=model.classifier[:-2]
model.eval()
img_data_a = datasets.ImageFolder(adda,transform=transforms.Compose([
                                                transforms.Resize(224),
#                                                transforms.CenterCrop(224),
                                                transforms.ToTensor(),
                                                transforms.Normalize(mean=[0.485, 0.456, 0.406], std=[0.229, 0.224, 0.225])])
                                            )
img_data_d = datasets.ImageFolder(addd,transform=transforms.Compose([
                                                transforms.Resize(224),
#                                                transforms.CenterCrop(224),
                                                transforms.ToTensor(),
                                                transforms.Normalize(mean=[0.485, 0.456, 0.406], std=[0.229, 0.224, 0.225])])
                                            )
img_data_w = datasets.ImageFolder(addw,transform=transforms.Compose([
                                                transforms.Resize(224),
#                                                transforms.CenterCrop(224),
                                                transforms.ToTensor(),
                                                transforms.Normalize(mean=[0.485, 0.456, 0.406], std=[0.229, 0.224, 0.225])])
                                            )

                                      
data_a=torch.utils.data.DataLoader(img_data_a, batch_size=200, shuffle=False)
data_d=torch.utils.data.DataLoader(img_data_d, batch_size=200, shuffle=False)
data_w=torch.utils.data.DataLoader(img_data_w, batch_size=200, shuffle=False)

with torch.no_grad():
    featurelista=[]
    for k, data in enumerate(data_a, 0):
        print(k)
        samples, labels = data
        feature=model(Variable(samples).to(device)).data.cpu().numpy()
        featurelista.append(feature)

    featurelistd=[]
    for k, data in enumerate(data_d, 0):
        print(k)
        samples, labels = data
        feature=model(Variable(samples).to(device)).data.cpu().numpy()
        featurelistd.append(feature)

    featurelistw=[]
    for k, data in enumerate(data_w, 0):
        print(k)
        samples, labels = data
        feature=model(Variable(samples).to(device)).data.cpu().numpy()
        featurelistw.append(feature)

feature_a=np.vstack((featurelista[0],featurelista[1]))
for i in range(len(featurelista)-2):
    feature_a=np.vstack((feature_a,featurelista[i+2]))
print(feature_a.shape)
feature_d=np.vstack((featurelistd[0],featurelistd[1]))
for i in range(len(featurelistd)-2):
    feature_d=np.vstack((feature_d,featurelistd[i+2]))
print(feature_d.shape)
feature_w=np.vstack((featurelistw[0],featurelistw[1]))
for i in range(len(featurelistw)-2):
    feature_w=np.vstack((feature_w,featurelistw[i+2]))
print(feature_w.shape)

label_a=np.array(img_data_a.targets)
label_d=np.array(img_data_d.targets)
label_w=np.array(img_data_w.targets)
np.save('./feature/feature_a_4096.npy',feature_a)
np.save('./feature/feature_d_4096.npy',feature_d)
np.save('./feature/feature_w_4096.npy',feature_w)
np.save('./feature/label_a.npy',label_a)
np.save('./feature/label_d.npy',label_d)
np.save('./feature/label_w.npy',label_w)





