import numpy as np
import matplotlib.pyplot as plt
import matplotlib

matplotlib.rcParams.update({'font.size': 15})

x = np.arange(0, 5.01, step=.01)
baseline_y = np.exp(x)
star_y = baseline_y + 27
accept_y = baseline_y + 38 + 15 * np.sin(x * x)
# minimax_y = 100 * np.ones(x.shape)
single_y = np.clip(baseline_y + 27 * (np.exp(1.8 * (x - 4))-1), a_min=np.exp(4), a_max=None)
plt.plot(x, baseline_y, "--", label=r"$\arg\inf_{\pi'}\; \ell(\pi', \Theta^{(r)})$ (r-dependent baseline)", linewidth=3)
plt.plot(x, star_y, label=r"$\pi_*$ (min-gap optimal)", linewidth=3)
# plt.plot(x, accept_y, label=r"acceptable policy, not min-gap optimal", linewidth=3)
# plt.plot(x, minimax_y)
plt.plot(x, single_y,
         label=r"$\pi_r = \arg\inf_{\pi} \{\; \ell(\pi, \Theta^{(r')}) := \sup_{\theta : \mathcal{C}(\theta) \leq r'} \ell(\pi,\theta) \}$",
         linewidth=3)

plt.legend()
plt.xlabel(r"$r$ (Difficulty)")
plt.ylabel("Performance Error (lower is better)")
plt.xticks([4], [r"$r'$"])
plt.yticks([])
plt.show()
