import torch
from utils.initial_x import getU, getV, getH

def UltraE_initial(n, p, d):
    theta = torch.randn(int(d / 2)).to(torch.float32)
    mu = torch.randn(int(d - p)).to(torch.float32)
    ksi = torch.randn(int(d / 2)).to(torch.float32)

    U = getU(theta)
    H = getH(d, p, torch.clamp(mu, -1, 1))
    V = getV(ksi)
    Q = torch.mm(U, torch.mm(H, V))

    P = torch.randn(n, d)

    return Q.to(torch.float32), theta, mu, ksi, P.to(torch.float32)
